/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.JaxxWidgetRuntimeException;
import org.nuiton.jaxx.widgets.ModelToBean;

public class MutateOnConditionalPropertyChangeListener<M extends ModelToBean>
implements PropertyChangeListener {
    private static final Log log = LogFactory.getLog(MutateOnConditionalPropertyChangeListener.class);
    private final M model;
    private final Method mutator;
    private final Predicate<M> canMutatePredicate;
    private final String propertyName;

    public MutateOnConditionalPropertyChangeListener(M model, Method mutator, Predicate canMutatePredicate) {
        Objects.requireNonNull(model);
        Objects.requireNonNull(mutator);
        Objects.requireNonNull(canMutatePredicate);
        this.model = model;
        this.mutator = mutator;
        this.canMutatePredicate = canMutatePredicate;
        this.propertyName = mutator.getName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.canMutatePredicate.test(this.model)) {
            Object newValue = evt.getNewValue();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Mutates property " + this.propertyName + " with value " + newValue + " on " + this.model));
            }
            try {
                this.mutator.invoke(this.model.getBean(), newValue);
            }
            catch (Exception e) {
                throw new JaxxWidgetRuntimeException("Can't mutate property " + this.propertyName + " on " + this.model, e);
            }
        }
    }
}

