/*
 * #%L
 * JAXX :: Validator
 * 
 * $Id: BeanValidatorMessage.java 2144 2010-12-30 13:06:21Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/jaxx/tags/jaxx-2.2.4/jaxx-validator/src/main/java/jaxx/runtime/validator/BeanValidatorMessage.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package jaxx.runtime.validator;

/**
 * The object to box a validation message.
 *
 * @author tchemit <chemit@codelutin.com>
 * @param <E> type of message (use for override {@link #compareTo(Object)}
 * method.
 * @since 1.3
 * @deprecated since 2.2.4, the code is moved into the org.nuiton:nuiton-validator project, will be removed in version 2.3
 */
@Deprecated
public class BeanValidatorMessage<E extends BeanValidatorMessage<?>> implements Comparable<E> {

    /** the validator that produce the message */
    protected BeanValidator<?> validator;

    /** the field that produce the message */
    protected BeanValidatorField<?> field;

    /** the label of the message (to be displayed somewhere) */
    protected String message;

    /** the scope of the message */
    protected BeanValidatorScope scope;

    public BeanValidatorMessage(BeanValidator<?> validator,
                                BeanValidatorField<?> field,
                                String message,
                                BeanValidatorScope scope) {
        this.field = field;
        this.validator = validator;
        this.message = message == null ? null : message.trim();
        this.scope = scope;
    }

    public BeanValidator<?> getValidator() {
        return validator;
    }

    public BeanValidatorField<?> getField() {
        return field;
    }

    public BeanValidatorScope getScope() {
        return scope;
    }

    public String getMessage() {
        return message;
    }

    @Override
    public int compareTo(E o) {
        // sort on scope
        int result = getScope().compareTo(o.getScope());
        if (result == 0) {
            // sort on field name
            result = field.getName().compareTo(o.field.getName());
            if (result == 0) {
                // sort on message
                result = message.compareTo(o.message);
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        BeanValidatorMessage<?> that = (BeanValidatorMessage<?>) o;

        return field.equals(that.field) &&
               message.equals(that.message) &&
               scope == that.scope;
    }

    @Override
    public int hashCode() {
        int result = field.hashCode();
        result = 31 * result + message.hashCode();
        result = 31 * result + scope.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return scope + " - " + field.getI18nError(message);
    }
}
