package org.nuiton.jaxx.swing.extra;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;

/**
 * Created on 4/5/15.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 3.0
 */
public class PropertyChangeListeners {

    /** Logger. */
    private static final Log log = LogFactory.getLog(PropertyChangeListeners.class);
    
    /**
     * Remove all listeners registred in given {@code pcs}.
     *
     * @param pcs the pcs to clean
     */
    public static void destroy(PropertyChangeSupport pcs) {
        PropertyChangeListener[] listeners = pcs.getPropertyChangeListeners();
        for (PropertyChangeListener l : listeners) {
            if (log.isInfoEnabled()) {
                if (l instanceof PropertyChangeListenerProxy) {
                    PropertyChangeListenerProxy ll = (PropertyChangeListenerProxy) l;
                    log.info("remove property change listener " + ll.getPropertyName() + " : " + l);
                } else {
                    log.info("remove property change listener " + l);
                }
            }
            pcs.removePropertyChangeListener(l);
        }
    }

    /**
     * Remove all listeners registred in given {@code component}.
     *
     * @param component the pcs to clean
     */
    public static void destroy(Component component) {
        PropertyChangeListener[] listeners = component.getPropertyChangeListeners();
        for (PropertyChangeListener l : listeners) {
            if (log.isInfoEnabled()) {
                if (l instanceof PropertyChangeListenerProxy) {
                    PropertyChangeListenerProxy ll = (PropertyChangeListenerProxy) l;
                    log.info("remove property change listener " + ll.getPropertyName() + " : " + l);
                } else {
                    log.info("remove property change listener " + l);
                }
            }
            component.removePropertyChangeListener(l);
        }
    }
}
