/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.validator.swing;

import javax.swing.JComponent;
import jaxx.runtime.validator.BeanValidator;
import jaxx.runtime.validator.BeanValidatorField;
import jaxx.runtime.validator.BeanValidatorMessage;
import jaxx.runtime.validator.BeanValidatorScope;
import jaxx.runtime.validator.swing.SwingValidator;

public class SwingValidatorMessage
extends BeanValidatorMessage<SwingValidatorMessage> {
    protected JComponent editor;
    protected String fieldName;

    public SwingValidatorMessage(SwingValidator validator, BeanValidatorField field, String message, BeanValidatorScope scope, JComponent editor) {
        super((BeanValidator)validator, field, message, scope);
        this.fieldName = field.getName();
        this.editor = editor;
    }

    public SwingValidatorMessage(SwingValidator validator, String fieldName, String message, BeanValidatorScope scope, JComponent editor) {
        super((BeanValidator)validator, null, message, scope);
        this.fieldName = fieldName;
        this.editor = editor;
    }

    public JComponent getEditor() {
        return this.editor;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public int compareTo(SwingValidatorMessage o) {
        int result = this.getScope().compareTo((Enum)o.getScope());
        if (result == 0 && (result = this.fieldName.compareTo(o.getFieldName())) == 0) {
            result = this.message.compareTo(o.getMessage());
        }
        return result;
    }

    public String toString() {
        String s = this.scope + " - " + (this.field == null ? this.message : this.field.getI18nError(this.message));
        if (this.editor == null) {
            return s;
        }
        return this.editor.getName() + " : " + s;
    }
}

