package jaxx.runtime.validator.swing;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JComponent;
import javax.swing.JList;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * A mouse listener to put on a {@link javax.swing.JList} with a {@link SwingValidatorMessageListModel} as a model.
 * <p/>
 * When a double click occurs, find the selected error in model and then focus to the associated component of error.
 *
 * @author chemit
 */
public class SwingValidatorMessageListMouseListener extends MouseAdapter {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(SwingValidatorMessageListMouseListener.class);

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getClickCount() == 2) {

            SwingValidatorMessage entry = getSelectedMessage(e);
            if (entry == null) {
                // no entry found
                return;
            }
            JComponent component = entry.getEditor();
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    protected SwingValidatorMessage getSelectedMessage(MouseEvent e) {
        JList list = (JList) e.getSource();
        if (!(list.getModel() instanceof SwingValidatorMessageListModel)) {
            log.warn("model must be a " + SwingValidatorMessageListModel.class + ", but was " + list.getModel());
            return null;
        }

        SwingValidatorMessageListModel model = (SwingValidatorMessageListModel) list.getModel();
        int index = list.getSelectionModel().getMinSelectionIndex();
        if (index == -1) {
            // nothing is selected
            return null;
        }
        SwingValidatorMessage entry = (SwingValidatorMessage) model.getElementAt(index);
        if (log.isDebugEnabled()) {
            log.debug("selected index: " + index + " : error: " + entry);
        }
        return entry;
    }

}