package jaxx.runtime.swing.wizard;

import javax.swing.JTabbedPane;

/**
 *
 * Contrat a respecter pour une ui de wizard.
 * 
 * @param <E> le type d'etape
 * @param <M> le type de model
 * 
 * @author tony
 * @since 1.3
 */
public interface WizardUI<E extends WizardStep, M extends WizardModel<E>> {

    /**
     * @return le modèle de wizard
     */
    M getModel();

    /**
     *
     * @return l'étape courante
     */
    E getSelectedStep();

    /**
     *
     * @return l'ui de l'étape courante
     */
    WizardStepUI<E, M> getSelectedStepUI();

    /**
     *
     * @param step l'étape donnée
     * @return l'ui de l'étape donnée
     */
    WizardStepUI<E, M> getStepUI(E step);

    /**
     *
     * @param stepIndex la position de l'étape
     * @return l'ui de l'étape donée
     */
    WizardStepUI<E, M> getStepUI(int stepIndex);

    /**
     * démarre le wizard
     */
    void start();

    /**
     * //TODO il faudrait supprimer cette méthode
     * @return le conteneur d'ui d'étapes
     */
    JTabbedPane getTabs();

    /**
     * Méthode invoqué lorsque la première opération du modèlé a été démarrée.
     */
    void onWasStarted();
    
    /**
     * Méthode invoquée lorsque l'univers des étapes a été modifié dans le
     * modèle.
     * 
     * @param steps les nouvelles étapes
     */
    void onStepsChanged(E[] steps);

    /**
     * Méthode invoquée lorsque l'étape courante a changé dans le modèle.
     *
     * @param newStep la nouvelle étape courante
     */
    void onStepChanged(E newStep);

    /**
     * Méthode invoquée lorsque l'état interne du modèle a changé.
     *
     * @param newState le nouvelle état du modèle de wizard
     */
    void onModelStateChanged(WizardOperationState newState);

    /**
     * Méthode invoqué lorsque l'état d'une opération a changé.
     *
     * @param step l'étape dont l'état a changé
     * @param newState le nouvel état pour l'étape donné
     */
    void onOperationStateChanged(E step,WizardOperationState newState) ;

}
