package jaxx.runtime.swing;

public class JAXXToggleButton extends javax.swing.JToggleButton {

    private static final long serialVersionUID = 1L;
    protected String glueText;
    protected String normalText;
    protected String glueTooltipText;
    protected String normalTooltipText;
    protected int normalMnemonic;
    protected int glueMnemonic;
    protected boolean _init;

    public String getGlueText() {
        return glueText;
    }

    public String getNormalText() {
        return normalText;
    }

    public String getGlueTooltipText() {
        return glueTooltipText;
    }

    public String getNormalTooltipText() {
        return normalTooltipText;
    }

    public void setGlueText(String glueText) {
        this.glueText = glueText;

    }

    public void setNormalText(String normalText) {
        this.normalText = normalText;

    }

    public void setGlueTooltipText(String glueTooltipText) {
        this.glueTooltipText = glueTooltipText;
    }

    public int getNormalMnemonic() {
        return normalMnemonic;
    }

    public void setNormalMnemonic(int normalMnemonic) {
        this.normalMnemonic = normalMnemonic;
    }

    public int getGlueMnemonic() {
        return glueMnemonic;
    }

    public void setGlueMnemonic(int glueMnemonic) {
        this.glueMnemonic = glueMnemonic;
    }

    public void setNormalTooltipText(String normalTooltipText) {
        this.normalTooltipText = normalTooltipText;
        if (!_init) {
            init();
            _init = true;
        }
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
        if (isSelected()) {
            setText(getGlueText());
            setToolTipText(getGlueTooltipText());
            setMnemonic(getGlueMnemonic());
        } else {
            setText(getNormalText());
            setToolTipText(getNormalTooltipText());
            setMnemonic(getNormalMnemonic());
        }
        revalidate();
    }

    public void init() {
        setSelected(false);
    }

    /* end raw body code */
    public JAXXToggleButton() {
        super();
        _init = false;
    }
}
