package jaxx.demo.component.jaxx.editor;

/*-
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2018 Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jaxx.demo.DemoPanel;
import jaxx.demo.entities.People;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.bean.BeanDoubleList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class BeanDoubleListDemo extends DemoPanel {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DOUBLE_LIST_FILTERABLE = "doubleList.filterable";
    public static final String BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT = "doubleList.highlightFilterText";
    public static final String BINDING_DOUBLE_LIST_SHOW_DECORATOR = "doubleList.showDecorator";
    public static final String BINDING_DOUBLE_LIST_SHOW_RESET = "doubleList.showReset";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1VTW9TRxS9cXESO9CkBBColKbhQ/GCZ2CFFFSoE0UtcgGRLBDeMPabxAPPM4+Z+8iLLKr+hP4Euu+mUnddVV10zYIN4i9UVRfdVr0zfnn+yDj2opEysu7cc+bMmXvv++lPKBoNXzxnaRroRKLo8OD+V0+ePGw+5y3c5KalRYxKQ+9vpgCFBiyEedwgXG7ULbyawasbqhMryeUAer0OZYMHETdtzhHhs2FEy5jqdr69nsaJPmTNRflY3/z9V+GH8PsfCwBpTOpKdJWVSaj+TU7UoSBChNN00itWjZjcIxlayD3Se8rGNiJmzAPW4S/hO5irw2zMNJEhrE5/Zcfh8GmMsHBlk3fUIyZ5dAPhlhMbUiRoHVIELsZDQSRBjTO5qZJmxOvCoIXGsSObRZi7ssNog2jOD93Z7NMNArdnM0s54HRLyV2xl2iGQkmngYL2nmkGuu+CNv1kjlraFRFybelqCaKSCGeHMBtt3npRU6nNX8xhF9pirx3RP245/A5PsYe3CWeGkxdNW+0/5oaPT1m2KZu8pUi90uPTemofyges1VZj08phbirCdY99mf9N8n/kETJ3NHw6BKMaDvo13C+ymQYUdUJheqbG0bJ/TFu9gj8/UvCW0O3+e2753a8fftk6rPIynX3WmzrQpFR9sVYx1yjs0Yu9Ek9QRNVvWbzeoF7hEXW46+CLHmHb2TaJo/M+sfDAwoOvmWkTRXHu/W+/n3v29iMobEE5UizcYjb/GyhhW5MLKgrT+O49p+jk/jytS1YbwmxT6ZCEQa0r+f7KjsCIhzUXW8O1VavEdYT1vvdMEdmeNclAAa9WKq9TMu6ix7hcfbP0xz/L2z/fOzRvhi5zYWx638DiU5gVMhKSuyGR9b93KCzEhieh6ve5r/PB235x1s1X3Vo54lYB4QRS4yBcO86WfocizPfelYcWqhOeJpb6uru6/VUFT0tPr6N6nA5Pyw8JKu6yyHgVjZ8W00u7epy0fMBM59DoQJpeRWWSinyGTafEN/f+JzVDo3LKh/LN10lyijRvxc3b8pHmuyKl8stF0Uevo2RA+4Ml/Hl3tD4DYbYzcWuV1winRoxc7XpcGgWVBmrgUnfkgUeTl721vNYdW6fDBD7rBr45kxyzUzJiB4qY4eM7IUO20hQypA/Tl0eYZ+xanshow7FdXvoZlqbQNG+LaOcg5sfwXCKe/wDrtnjXVgoAAA==";
    private static final Log log = LogFactory.getLog(BeanDoubleListDemo.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean allComponentsCreated;

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel configurationPanel;
    protected BeanDoubleList<People> doubleList;
    protected JCheckBox filterOnNachoButton;
    protected JCheckBox filterableButton;
    protected final BeanDoubleListDemoHandler handler = createHandler();
    protected JCheckBox highlightFilterTextButton;
    protected JCheckBox showDecoratorButton;
    protected JCheckBox showResetButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private BeanDoubleListDemo $DemoPanel0 = this;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public BeanDoubleListDemo(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, LayoutManager param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public BeanDoubleListDemo(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, LayoutManager param1) {
        super(param0 ,param1);
        $initialize();
    }

    public BeanDoubleListDemo() {
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(boolean param0) {
        super(param0);
        $initialize();
    }

    public BeanDoubleListDemo(JAXXContext param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public BeanDoubleList<People> getDoubleList() {
        return doubleList;
    }

    public JCheckBox getFilterOnNachoButton() {
        return filterOnNachoButton;
    }

    public JCheckBox getFilterableButton() {
        return filterableButton;
    }

    public BeanDoubleListDemoHandler getHandler() {
        return handler;
    }

    public JCheckBox getHighlightFilterTextButton() {
        return highlightFilterTextButton;
    }

    public JCheckBox getShowDecoratorButton() {
        return showDecoratorButton;
    }

    public JCheckBox getShowResetButton() {
        return showResetButton;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(filterableButton);
        configurationPanel.add(highlightFilterTextButton);
        configurationPanel.add(showResetButton);
        configurationPanel.add(showDecoratorButton);
        configurationPanel.add(filterOnNachoButton);
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new GridLayout(0,1));
    }

    protected void createDoubleList() {
        $objectMap.put("doubleList", doubleList = new BeanDoubleList<People>());
        
        doubleList.setName("doubleList");
        doubleList.setI18nPrefix("jaxxdemo.common.");
    }

    protected void createFilterOnNachoButton() {
        $objectMap.put("filterOnNachoButton", filterOnNachoButton = new JCheckBox());
        
        filterOnNachoButton.setName("filterOnNachoButton");
        filterOnNachoButton.setText(t("jaxxdemo.beandoublelistdemo.filterOnNacho"));
        filterOnNachoButton.setSelected(false);
    }

    protected void createFilterableButton() {
        $objectMap.put("filterableButton", filterableButton = new JCheckBox());
        
        filterableButton.setName("filterableButton");
        filterableButton.setText(t("jaxxdemo.beandoublelistdemo.filterable"));
        filterableButton.setSelected(true);
    }

    protected BeanDoubleListDemoHandler createHandler() {
        return new BeanDoubleListDemoHandler();
    }

    protected void createHighlightFilterTextButton() {
        $objectMap.put("highlightFilterTextButton", highlightFilterTextButton = new JCheckBox());
        
        highlightFilterTextButton.setName("highlightFilterTextButton");
        highlightFilterTextButton.setText(t("jaxxdemo.beandoublelistdemo.highlightFilterText"));
        highlightFilterTextButton.setSelected(false);
    }

    protected void createShowDecoratorButton() {
        $objectMap.put("showDecoratorButton", showDecoratorButton = new JCheckBox());
        
        showDecoratorButton.setName("showDecoratorButton");
        showDecoratorButton.setText(t("jaxxdemo.beandoublelistdemo.showDecorator"));
        showDecoratorButton.setSelected(true);
    }

    protected void createShowResetButton() {
        $objectMap.put("showResetButton", showResetButton = new JCheckBox());
        
        showResetButton.setName("showResetButton");
        showResetButton.setText(t("jaxxdemo.beandoublelistdemo.showReset"));
        showResetButton.setSelected(true);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $DemoPanel0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add(configurationPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(doubleList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToConfigurationPanel();
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        doubleList.setBeanType(People.class);
        configurationPanel.setBorder(new TitledBorder(t("jaxxdemo.beandoublelistdemo.configuration")));
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("$DemoPanel0", $DemoPanel0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createConfigurationPanel();
        createFilterableButton();
        createHighlightFilterTextButton();
        createShowResetButton();
        createShowDecoratorButton();
        createFilterOnNachoButton();
        createDoubleList();
        // inline creation of $DemoPanel0
        setName("$DemoPanel0");
        setLayout(new BorderLayout());
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
        handler.afterInit(this);
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_FILTERABLE, true) {
        
            @Override
            public void applyDataBinding() {
                if (filterableButton != null) {
                    $bindingSources.put("filterableButton.getModel()", filterableButton.getModel());
                    filterableButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    filterableButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_FILTERABLE));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (filterableButton != null) {
                    doubleList.setFilterable(filterableButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (filterableButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("filterableButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u0"));
                    }
                    filterableButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_FILTERABLE));
                }
            }
        
            public void $pr$u0(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SHOW_DECORATOR, true) {
        
            @Override
            public void applyDataBinding() {
                if (showDecoratorButton != null) {
                    $bindingSources.put("showDecoratorButton.getModel()", showDecoratorButton.getModel());
                    showDecoratorButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    showDecoratorButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_DECORATOR));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showDecoratorButton != null) {
                    doubleList.setShowDecorator(showDecoratorButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showDecoratorButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showDecoratorButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u1"));
                    }
                    showDecoratorButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_DECORATOR));
                }
            }
        
            public void $pr$u1(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_SHOW_RESET, true) {
        
            @Override
            public void applyDataBinding() {
                if (showResetButton != null) {
                    $bindingSources.put("showResetButton.getModel()", showResetButton.getModel());
                    showResetButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    showResetButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_RESET));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (showResetButton != null) {
                    doubleList.setShowReset(showResetButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (showResetButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("showResetButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u2"));
                    }
                    showResetButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_SHOW_RESET));
                }
            }
        
            public void $pr$u2(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (highlightFilterTextButton != null) {
                    $bindingSources.put("highlightFilterTextButton.getModel()", highlightFilterTextButton.getModel());
                    highlightFilterTextButton.getModel().addChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    highlightFilterTextButton.addPropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (highlightFilterTextButton != null) {
                    doubleList.setHighlightFilterText(highlightFilterTextButton.isSelected());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (highlightFilterTextButton != null) {
                    ButtonModel $target = (ButtonModel) $bindingSources.remove("highlightFilterTextButton.getModel()");
                    if ($target != null) {
                        $target.removeChangeListener( JAXXUtil.getEventListener(ChangeListener.class, this, "$pr$u3"));
                    }
                    highlightFilterTextButton.removePropertyChangeListener("model", JAXXUtil.getDataBindingUpdateListener(jaxx.demo.component.jaxx.editor.BeanDoubleListDemo.this, BINDING_DOUBLE_LIST_HIGHLIGHT_FILTER_TEXT));
                }
            }
        
            public void $pr$u3(ChangeEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug(event);
                }
                propertyChange(null);
            }
        });
    }

}
