/*
 * #%L
 * JAXX :: Compiler
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package jaxx.compiler.decorators;

import jaxx.compiler.CompiledObject;
import jaxx.compiler.CompiledObject.ChildRef;
import jaxx.compiler.CompiledObjectDecorator;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import jaxx.compiler.java.JavaFile;
import jaxx.runtime.SwingUtil;

/**
 * A decorator to surround a compiled object (should be a component at least)
 * with a JXLayer.
 *
 * @author Tony Chemit - chemit@codelutin.com
 * @since 1.2
 */
@org.codehaus.plexus.component.annotations.Component(role = CompiledObjectDecorator.class, hint = "boxed")
public class BoxedCompiledObjectDecorator extends DefaultCompiledObjectDecorator {

    @Override
    public String getName() {
        return "boxed";
    }

    @Override
    public void finalizeCompiler(JAXXCompiler compiler,
                                 CompiledObject root,
                                 CompiledObject object,
                                 JavaFile javaFile,
                                 String packageName,
                                 String className,
                                 String fullClassName) throws ClassNotFoundException {
        CompiledObject parent = object.getParent();
        if (parent == null) {
            parent = root;
        }
        for (ChildRef child : parent.getChilds()) {
            if (child.getChild() == object) {
                String javaCode = child.getChildJavaCode();
                String type = compiler.getImportedType(SwingUtil.class);
                child.setChildJavaCode(
                        type +
                        ".boxComponentWithJxLayer(" + javaCode + ")");
                break;
            }
        }
        super.finalizeCompiler(compiler,
                               root,
                               object,
                               javaFile,
                               packageName,
                               className,
                               fullClassName
        );
    }
}
