/*
 * Decompiled with CFR 0.152.
 */
package jaxx.compiler.finalizers;

import javax.swing.SwingUtilities;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.compiler.finalizers.AbstractFinalizer;
import jaxx.compiler.finalizers.DefaultFinalizer;
import jaxx.compiler.finalizers.JAXXCompilerFinalizer;
import jaxx.compiler.java.JavaElementFactory;
import jaxx.compiler.java.JavaFile;
import jaxx.compiler.reflect.ClassDescriptor;
import jaxx.compiler.reflect.ClassDescriptorHelper;
import jaxx.runtime.swing.Application;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=JAXXCompilerFinalizer.class, hint="swing")
public class SwingFinalizer
extends AbstractFinalizer {
    protected static final Log log = LogFactory.getLog(DefaultFinalizer.class);

    @Override
    public boolean accept(JAXXCompiler compiler) {
        ClassDescriptor descriptor = ClassDescriptorHelper.getClassDescriptor(Application.class);
        CompiledObject root = compiler.getRootObject();
        return descriptor.isAssignableFrom(root.getObjectClass());
    }

    @Override
    public void finalizeCompiler(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) {
    }

    @Override
    public void prepareJavaFile(CompiledObject root, JAXXCompiler compiler, JavaFile javaFile, String packageName, String className) throws ClassNotFoundException {
        if (compiler.isMainDeclared()) {
            return;
        }
        javaFile.addImport(SwingUtilities.class);
        String code = "SwingUtilities.invokeLater(new Runnable() { public void run() { new " + className + "().setVisible(true); } });";
        javaFile.addMethod(JavaElementFactory.newMethod(9, "void", "main", code, false, JavaElementFactory.newArgument("String[]", "arg")));
    }
}

