/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.swing;

import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptor;
import jaxx.reflect.ClassDescriptorLoader;
import jaxx.tags.DefaultComponentHandler;
import org.w3c.dom.Element;

import javax.swing.JPopupMenu;

public class JPopupMenuHandler extends DefaultComponentHandler {
    public JPopupMenuHandler(ClassDescriptor beanClass) {
        super(beanClass);
        ClassDescriptorLoader.checkSupportClass(getClass(), beanClass, JPopupMenu.class);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    protected void openComponent(CompiledObject object, Element tag, JAXXCompiler compiler) {
        compiler.openInvisibleComponent(object);
    }
}