/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.tags.swing;

import jaxx.CompilerException;
import jaxx.compiler.CompiledObject;
import jaxx.compiler.JAXXCompiler;
import jaxx.reflect.ClassDescriptor;
import jaxx.runtime.swing.Item;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/** Compiled representation of a class that contains Items arranged in a list or tree structure (JComboBox, JList, JTree). */
class CompiledItemContainer extends CompiledObject {
    private List<Item> items = new ArrayList<Item>();
    private Stack<Item> openNodes = new Stack<Item>();

    public CompiledItemContainer(String id, ClassDescriptor objectClass, JAXXCompiler compiler) throws CompilerException {
        super(id, objectClass, compiler);
    }


    public void openItem(Item item) {
        if (openNodes.isEmpty()) {
            items.add(item);
        } else {
            Item openNode = openNodes.peek();
            openNode.addChild(item);
        }
        openNodes.add(item);
    }


    public void closeItem(Item item) {
        if (openNodes.pop() != item) {
            throw new IllegalArgumentException(item + " was not at the top of the item stack");
        }
    }


    public List<Item> getItems() {
        return items;
    }


    public void setItems(List<Item> items) {
        this.items = items;
    }
}