/*
 * Copyright 2006 Ethan Nicholas. All rights reserved.
 * Use is subject to license terms.
 */
package jaxx.types;

import jaxx.types.*;
import java.awt.GridBagConstraints;

public class GridBagConstraintsConverter implements TypeConverter {
    public String getJavaCode(Object object) {
        GridBagConstraints g = (GridBagConstraints) object;
        return "new GridBagConstraints(" + g.gridx + ", " + g.gridy + ", " + g.gridwidth + ", " + g.gridheight + ", " +
                g.weightx + ", " + g.weighty + ", " + g.anchor + ", " + g.fill + ", " +
                TypeManager.getJavaCode(g.insets) + ", " + g.ipadx + ", " + g.ipady + ")";
    }


    public Object convertFromString(String string, Class type) {
        throw new UnsupportedOperationException("GridBagConstraints must be represented using Java code");
    }
}