/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

public class ParserThread
extends Thread {
    private static final Log log = LogFactory.getLog(ParserThread.class);
    protected final BlockingQueue<ParserTask> tasks;
    protected final List<File> treatedFiles;
    protected final List<File> touchedFiles;
    protected final SortedProperties result;
    private final Object lock = new Object();
    protected int nbFiles;

    public ParserThread(SortedProperties result) {
        super(ParserThread.class.getSimpleName());
        this.result = result;
        this.tasks = new LinkedBlockingQueue<ParserTask>();
        this.touchedFiles = new ArrayList<File>();
        this.treatedFiles = new ArrayList<File>();
    }

    public List<File> getTreatedFiles() {
        return this.treatedFiles;
    }

    public List<File> getTouchedFiles() {
        return this.touchedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFile(FileParser parser, File ... files) {
        BlockingQueue<ParserTask> blockingQueue = this.tasks;
        synchronized (blockingQueue) {
            for (File f : files) {
                ++this.nbFiles;
                if (log.isInfoEnabled()) {
                    log.info((Object)("[" + this.nbFiles + "] " + f));
                }
                this.tasks.offer(new ParserTask(parser, f));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminatesAndWaits() {
        Object object = this.tasks;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"add terminate runner");
            }
            this.tasks.offer(new ParserTask(null, null));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"block until ends...");
        }
        object = this.lock;
        synchronized (object) {
            block12: {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    if (!log.isErrorEnabled()) break block12;
                    log.error((Object)e);
                }
            }
        }
        if (this.nbFiles != this.treatedFiles.size()) {
            throw new IllegalStateException("should have " + this.nbFiles + " files treated, but found " + this.treatedFiles.size());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"thread is terminated.");
        }
    }

    public void clear() {
        this.treatedFiles.clear();
        this.touchedFiles.clear();
        this.nbFiles = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object runner;
        ThreadFactory factory = new ThreadFactory(){
            final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = this.defaultFactory.newThread(r);
                thread.setName(ParserThread.this + "-" + thread.getName());
                return thread;
            }
        };
        ThreadPoolExecutor service = new ThreadPoolExecutor(8, 10, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue(), factory){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                ParserTask i18n = (ParserTask)r;
                i18n.registerResult(ParserThread.this.treatedFiles, ParserThread.this.touchedFiles, ParserThread.this.result);
            }
        };
        while (true) {
            try {
                runner = this.tasks.take();
            }
            catch (InterruptedException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)e);
                continue;
            }
            if (((ParserTask)runner).getFile() == null) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"no more files to treate, wait termination...");
                }
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("consume " + runner));
            }
            service.execute((Runnable)runner);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("after consume " + runner));
        }
        service.shutdown();
        if (log.isInfoEnabled()) {
            log.info((Object)("will waits until ends of all " + this.nbFiles + " runner(s)!"));
        }
        while (true) {
            if (service.isTerminated()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("all runners are terminated. [" + this.treatedFiles.size() + "]"));
                }
                runner = this.lock;
                synchronized (runner) {
                    this.lock.notifyAll();
                    break;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"waiting end...");
            }
            try {
                ParserThread.sleep(200L);
            }
            catch (InterruptedException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)e);
            }
        }
    }

    class ParserTask
    implements Runnable {
        protected final FileParser parser;
        protected final File file;
        protected long startingTime;
        protected long endingTime;

        ParserTask(FileParser parser, File file) {
            this.parser = parser;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.startingTime = System.nanoTime();
            if (log.isDebugEnabled()) {
                log.debug((Object)("starting action for " + this.file));
            }
            try {
                this.parser.parseFile(this.file);
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("could not parse file " + this.file), (Throwable)e);
                }
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("ending action for " + this.file));
                }
                this.endingTime = System.nanoTime();
            }
        }

        public String toString() {
            return super.toString() + " - " + this.file;
        }

        protected File getFile() {
            return this.file;
        }

        protected long getDelay() {
            return this.endingTime - this.startingTime;
        }

        protected void destroy() {
            this.parser.destroy();
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.destroy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void registerResult(List<File> treatedFiles, List<File> touchedFiles, SortedProperties result) {
            try {
                String delay;
                treatedFiles.add(this.file);
                if (log.isDebugEnabled()) {
                    delay = PluginHelper.convertTime((long)this.getDelay());
                    log.debug((Object)("[" + treatedFiles.size() + "] " + this.file + " in " + delay));
                }
                if (this.parser.isTouched()) {
                    touchedFiles.add(this.file);
                    if (this.parser.isShowTouchedFiles()) {
                        this.parser.getLog().info((CharSequence)("touch " + this.file));
                    }
                    if (log.isInfoEnabled()) {
                        delay = PluginHelper.convertTime((long)this.getDelay());
                        log.info((Object)("[" + treatedFiles.size() + "] touchs " + this.file + " in " + delay));
                    }
                    result.putAll((Map)this.parser.getResult());
                }
            }
            finally {
                this.destroy();
            }
        }
    }
}

