/**
 * *##% guix-compiler-swing
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */
package org.nuiton.guix.tags.swing;

import javax.swing.event.MenuListener;

/**
 * Handles the Menu tag
 *
 * @author kmorin
 */
public class MenuHandler extends ComponentHandler {

    /**
     * Constructor
     */
    public MenuHandler() {
        super();
    }

    @Override
    public Class getClassToGenerate() {
        return javax.swing.JMenu.class;
    }

    @Override
    protected void configureProxyEventInfo() {
        super.configureProxyEventInfo();
        addProxyEventInfo("isSelected", MenuListener.class);
    }
}
