/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.renderer;

import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.reporting.AbstractMavenReportRenderer;
import org.codehaus.plexus.i18n.I18N;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelClassifier;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.eugene.models.object.ObjectModelEnumeration;
import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;
import org.nuiton.eugene.models.object.ObjectModelParameter;

public abstract class AbstractEugeneReportRenderer<D, DD>
extends AbstractMavenReportRenderer {
    protected final I18N i18n;
    protected final Locale locale;
    protected final String bundleName;
    protected final D data;
    protected final String javaDocDestDir;
    protected final String jxrDestDir;

    protected abstract Map<String, DD> getDataDetails();

    public AbstractEugeneReportRenderer(Sink sink, I18N i18n, Locale locale, String bundleName, String javaDocDestDir, String jxrDestDir, D data) {
        super(sink);
        this.i18n = i18n;
        this.locale = locale;
        this.bundleName = bundleName;
        this.javaDocDestDir = javaDocDestDir;
        this.jxrDestDir = jxrDestDir;
        this.data = data;
        this.sink = sink;
    }

    public String getTitle() {
        return this.getText("report.title");
    }

    public void renderBody() {
        String implementation = this.data.getClass().getName();
        this.sink.section1();
        this.sink.sectionTitle1();
        this.sink.text(this.getText("report.overview.title"));
        this.sink.sectionTitle1_();
        this.sink.lineBreak();
        this.sink.paragraph();
        this.sink.text(this.getText("report.overview.text"));
        this.sink.text(" ");
        this.sink.bold();
        this.sink.text(implementation);
        this.sink.bold_();
        this.sink.text(" ");
        this.sink.link("./" + this.javaDocDestDir + "/" + implementation.replace('.', '/') + ".html");
        this.sink.text("javadoc");
        this.sink.link_();
        this.sink.link("./" + this.jxrDestDir + "/" + implementation.replace('.', '/') + ".html");
        this.sink.text(" ");
        this.sink.text("xref");
        this.sink.link_();
        this.sink.text(".");
        this.sink.paragraph_();
        this.sink.paragraph();
        this.sink.link(this.getEugeneDocLink());
        this.sink.text(this.getText("report.overview.more.information"));
        this.sink.link_();
        this.sink.paragraph_();
        Map<String, DD> detailEntries = this.getDataDetails();
        this.renderSummaryTable(this.data, detailEntries);
        this.sink.section1_();
        if (MapUtils.isNotEmpty(detailEntries)) {
            this.sink.section1();
            this.sink.sectionTitle1();
            this.sink.text(this.getText("report.detail.title"));
            this.sink.sectionTitle1_();
            this.sink.lineBreak();
            this.sink.paragraph();
            this.sink.text(this.getText("report.detail.text"));
            this.sink.paragraph_();
            for (Map.Entry<String, DD> detailEntry : detailEntries.entrySet()) {
                this.renderDetail(detailEntry.getKey(), detailEntry.getValue());
            }
            this.sink.section1_();
        }
    }

    protected abstract String getEugeneDocLink();

    protected abstract void renderSummaryTable(D var1, Map<String, DD> var2);

    protected abstract void renderDetail(String var1, DD var2);

    protected String getText(boolean key) {
        return this.getText("report." + String.valueOf(key));
    }

    protected String getText(String key) {
        return this.i18n.getString(this.bundleName, this.locale, key);
    }

    protected void renderWarningIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_warning_sml.gif");
        this.sink.figure_();
    }

    protected void renderErrorIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_error_sml.gif");
        this.sink.figure_();
    }

    protected void renderSuccessIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_success_sml.gif");
        this.sink.figure_();
    }

    protected void renderInfoIcon() {
        this.sink.figure();
        this.sink.figureGraphics("images/icon_info_sml.gif");
        this.sink.figure_();
    }

    protected void sinkHeaderCellText(String text) {
        this.sink.tableHeaderCell();
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void sinkHeaderCellText(SinkEventAttributes width, String text) {
        this.sink.tableHeaderCell(width);
        this.sink.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void sinkCellText(SinkEventAttributes width, String text) {
        this.sink.tableCell(width);
        this.sink.text(text);
        this.sink.tableCell_();
    }

    protected void sinkCellText(String text) {
        this.sink.tableCell();
        this.sink.text(text);
        this.sink.tableCell_();
    }

    protected void sinkCellVerbatimText(String text) {
        this.sink.tableCell();
        this.sink.verbatim(SinkEventAttributeSet.MONOSPACED);
        this.sink.text(text);
        this.sink.verbatim_();
        this.sink.tableCell_();
    }

    protected void sinkCellLink(String text, String url) {
        this.sink.tableCell();
        this.sink.link(url);
        this.sink.text(text);
        this.sink.link_();
        this.sink.tableCell_();
    }

    protected void renderTargets(Class<?> ... targets) {
        boolean moreThanOne;
        boolean bl = moreThanOne = targets.length > 1;
        if (moreThanOne) {
            this.sink.list_();
        }
        for (Class<?> target : targets) {
            if (moreThanOne) {
                this.sink.listItem();
            }
            this.renderDetailTarget(target);
            if (!moreThanOne) continue;
            this.sink.listItem_();
        }
        if (moreThanOne) {
            this.sink.list_();
        }
    }

    protected void renderDetailTarget(Class<?> target) {
        if (ObjectModel.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.model"));
        } else if (ObjectModelClassifier.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.classifier"));
        } else if (ObjectModelClass.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.class"));
        } else if (ObjectModelInterface.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.interface"));
        } else if (ObjectModelEnumeration.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.enumeration"));
        } else if (ObjectModelAttribute.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.attribute"));
        } else if (ObjectModelParameter.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.parameter"));
        } else if (ObjectModelOperation.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.operation"));
        } else if (ObjectModelElement.class.isAssignableFrom(target)) {
            this.sink.text(this.getText("report.detail.target.element"));
        }
    }
}

