/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.LabelChainWalker;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.consistency.store.RecordReference;
import org.neo4j.kernel.impl.store.DynamicNodeLabels;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;

public class NodeLabelReader {
    public static <RECORD extends AbstractBaseRecord, REPORT extends ConsistencyReport> Set<Long> getListOfLabels(NodeRecord nodeRecord, RecordAccess records, CheckerEngine<RECORD, REPORT> engine) {
        final HashSet<Long> labels = new HashSet<Long>();
        NodeLabels nodeLabels = NodeLabelsField.parseLabelsField((NodeRecord)nodeRecord);
        if (nodeLabels instanceof DynamicNodeLabels) {
            DynamicNodeLabels dynamicNodeLabels = (DynamicNodeLabels)nodeLabels;
            long firstRecordId = dynamicNodeLabels.getFirstDynamicRecordId();
            RecordReference<DynamicRecord> firstRecordReference = records.nodeLabels(firstRecordId);
            engine.comparativeCheck(firstRecordReference, new LabelChainWalker(new LabelChainWalker.Validator<RECORD, REPORT>(){

                @Override
                public void onRecordNotInUse(DynamicRecord dynamicRecord, CheckerEngine<RECORD, REPORT> engine) {
                }

                @Override
                public void onRecordChainCycle(DynamicRecord record, CheckerEngine<RECORD, REPORT> engine) {
                }

                @Override
                public void onWellFormedChain(long[] labelIds, CheckerEngine<RECORD, REPORT> engine, RecordAccess records) {
                    NodeLabelReader.copyToSet(labelIds, labels);
                }
            }));
        } else {
            NodeLabelReader.copyToSet(nodeLabels.get(null), labels);
        }
        return labels;
    }

    public static long[] getListOfLabels(NodeRecord nodeRecord, RecordStore<DynamicRecord> labels) {
        long field = nodeRecord.getLabelField();
        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels((long)field)) {
            ArrayList<DynamicRecord> recordList = new ArrayList<DynamicRecord>();
            PrimitiveLongSet alreadySeen = Primitive.longSet((int)16);
            long id = NodeLabelsField.firstDynamicLabelRecordId((long)field);
            while (!Record.NULL_REFERENCE.is(id)) {
                DynamicRecord record = (DynamicRecord)labels.forceGetRecord(id);
                if (!record.inUse() || !alreadySeen.add(id)) {
                    return PrimitiveLongCollections.EMPTY_LONG_ARRAY;
                }
                recordList.add(record);
            }
            return LabelChainWalker.labelIds(recordList);
        }
        return NodeLabelsField.get((NodeRecord)nodeRecord, null);
    }

    public static Set<Long> getListOfLabels(long labelField) {
        HashSet<Long> labels = new HashSet<Long>();
        NodeLabelReader.copyToSet(InlineNodeLabels.parseInlined((long)labelField), labels);
        return labels;
    }

    private static void copyToSet(long[] array, Set<Long> set) {
        for (long labelId : array) {
            set.add(labelId);
        }
    }
}

