/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.lang.reflect.Array;
import java.util.List;
import org.neo4j.consistency.ConsistencyCheckSettings;
import org.neo4j.consistency.checking.CheckDecorator;
import org.neo4j.consistency.checking.DynamicStore;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.full.ConsistencyCheckTasks;
import org.neo4j.consistency.checking.full.ConsistencyCheckerTask;
import org.neo4j.consistency.checking.full.CountsBuilderDecorator;
import org.neo4j.consistency.checking.full.MultiPassStore;
import org.neo4j.consistency.checking.full.OwnerCheck;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.checking.full.TaskExecutor;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.consistency.store.CacheSmallStoresRecordAccess;
import org.neo4j.consistency.store.DirectRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.api.direct.DirectStoreAccess;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.logging.Log;

public class FullCheck {
    private final boolean checkPropertyOwners;
    private final boolean checkLabelScanStore;
    private final boolean checkIndexes;
    private final ProgressMonitorFactory progressFactory;
    private final IndexSamplingConfig samplingConfig;
    private final boolean checkGraph;
    private final int threads;
    private final Statistics statistics;

    public FullCheck(Config tuningConfiguration, ProgressMonitorFactory progressFactory, Statistics statistics, int threads) {
        this.statistics = statistics;
        this.threads = threads;
        this.checkPropertyOwners = (Boolean)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_property_owners);
        this.checkLabelScanStore = (Boolean)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_label_scan_store);
        this.checkIndexes = (Boolean)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_indexes);
        this.checkGraph = (Boolean)tuningConfiguration.get(ConsistencyCheckSettings.consistency_check_graph);
        this.samplingConfig = new IndexSamplingConfig(tuningConfiguration);
        this.progressFactory = progressFactory;
    }

    public ConsistencySummaryStatistics execute(DirectStoreAccess stores, Log log) throws ConsistencyCheckIncompleteException {
        return this.execute(stores, log, ConsistencyReporter.NO_MONITOR);
    }

    ConsistencySummaryStatistics execute(DirectStoreAccess stores, Log log, ConsistencyReporter.Monitor reportMonitor) throws ConsistencyCheckIncompleteException {
        ConsistencySummaryStatistics summary = new ConsistencySummaryStatistics();
        InconsistencyReport report = new InconsistencyReport(new InconsistencyMessageLogger(log), summary);
        OwnerCheck ownerCheck = new OwnerCheck(this.checkPropertyOwners, new DynamicStore[0]);
        CountsBuilderDecorator countsBuilder = new CountsBuilderDecorator(stores.nativeStores());
        CheckDecorator.ChainCheckDecorator decorator = new CheckDecorator.ChainCheckDecorator(ownerCheck, countsBuilder);
        DefaultCacheAccess cacheAccess = new DefaultCacheAccess(this.statistics.getCounts(), this.threads);
        RecordAccess records = FullCheck.recordAccess(stores.nativeStores(), cacheAccess);
        this.execute(stores, decorator, records, report, cacheAccess, reportMonitor);
        ownerCheck.scanForOrphanChains(this.progressFactory);
        if (this.checkGraph) {
            CountsAccessor countsAccessor = stores.nativeStores().getCounts();
            if (countsAccessor instanceof CountsTracker) {
                CountsTracker tracker = (CountsTracker)countsAccessor;
                try {
                    tracker.start();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            countsBuilder.checkCounts(countsAccessor, new ConsistencyReporter(records, report), this.progressFactory);
        }
        if (!summary.isConsistent()) {
            log.warn("Inconsistencies found: " + summary);
        }
        return summary;
    }

    void execute(DirectStoreAccess directStoreAccess, CheckDecorator decorator, RecordAccess recordAccess, InconsistencyReport report, CacheAccess cacheAccess, ConsistencyReporter.Monitor reportMonitor) throws ConsistencyCheckIncompleteException {
        ConsistencyReporter reporter = new ConsistencyReporter(recordAccess, report, reportMonitor);
        StoreProcessor processEverything = new StoreProcessor(decorator, reporter, Stage.SEQUENTIAL_FORWARD, cacheAccess);
        ProgressMonitorFactory.MultiPartBuilder progress = this.progressFactory.multipleParts("Full Consistency Check");
        StoreAccess nativeStores = directStoreAccess.nativeStores();
        try (IndexAccessors indexes = new IndexAccessors(directStoreAccess.indexes(), (RecordStore<DynamicRecord>)nativeStores.getSchemaStore(), this.samplingConfig);){
            MultiPassStore.Factory multiPass = new MultiPassStore.Factory(decorator, recordAccess, cacheAccess, report, reportMonitor);
            ConsistencyCheckTasks taskCreator = new ConsistencyCheckTasks(progress, processEverything, nativeStores, this.statistics, cacheAccess, directStoreAccess.labelScanStore(), indexes, multiPass, reporter, this.threads);
            List<ConsistencyCheckerTask> tasks = taskCreator.createTasksForFullCheck(this.checkLabelScanStore, this.checkIndexes, this.checkGraph);
            TaskExecutor.execute(tasks, progress.build());
        }
        catch (Exception e) {
            throw new ConsistencyCheckIncompleteException(e);
        }
    }

    static RecordAccess recordAccess(StoreAccess store, CacheAccess cacheAccess) {
        return new CacheSmallStoresRecordAccess(new DirectRecordAccess(store, cacheAccess), (PropertyKeyTokenRecord[])FullCheck.readAllRecords(PropertyKeyTokenRecord.class, (RecordStore)store.getPropertyKeyTokenStore()), (RelationshipTypeTokenRecord[])FullCheck.readAllRecords(RelationshipTypeTokenRecord.class, (RecordStore)store.getRelationshipTypeTokenStore()), (LabelTokenRecord[])FullCheck.readAllRecords(LabelTokenRecord.class, (RecordStore)store.getLabelTokenStore()));
    }

    private static <T extends AbstractBaseRecord> T[] readAllRecords(Class<T> type, RecordStore<T> store) {
        AbstractBaseRecord[] records = (AbstractBaseRecord[])Array.newInstance(type, (int)store.getHighId());
        for (int i = 0; i < records.length; ++i) {
            records[i] = store.forceGetRecord((long)i);
        }
        return records;
    }
}

