/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transport.quartz.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleException;
import org.mule.api.annotations.Schedule;
import org.mule.api.annotations.meta.Channel;
import org.mule.api.annotations.meta.ChannelType;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.transport.Connector;
import org.mule.config.endpoint.AbstractEndpointAnnotationParser;
import org.mule.config.endpoint.AnnotatedEndpointData;
import org.mule.transport.quartz.QuartzConnector;
import org.mule.transport.quartz.config.ScheduleConfigBuilder;
import org.mule.transport.quartz.jobs.EventGeneratorJobConfig;
import org.mule.util.CollectionUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;

public class ScheduleAnnotationParser
extends AbstractEndpointAnnotationParser {
    public InboundEndpoint parseInboundEndpoint(Annotation annotation, Map metaInfo) throws MuleException {
        Schedule schedule = (Schedule)annotation;
        ScheduleConfigBuilder builder = (ScheduleConfigBuilder)this.lookupConfig(schedule.config(), ScheduleConfigBuilder.class);
        if (builder != null) {
            return builder.buildScheduler();
        }
        return super.parseInboundEndpoint(annotation, Collections.emptyMap());
    }

    protected AnnotatedEndpointData createEndpointData(Annotation annotation) throws MuleException {
        Schedule schedule = (Schedule)annotation;
        String uri = "quartz://schedule" + UUID.getUUID();
        AnnotatedEndpointData epData = new AnnotatedEndpointData(MessageExchangePattern.ONE_WAY, ChannelType.Inbound, annotation);
        epData.setProperties((Map)this.convertProperties(this.getProperties(schedule)));
        String threads = (String)epData.getProperties().get("threads");
        if (threads == null) {
            threads = "1";
            epData.getProperties().put("threads", threads);
        }
        epData.setAddress(uri);
        epData.setConnector((Connector)this.getConnector());
        EventGeneratorJobConfig config = new EventGeneratorJobConfig();
        config.setStateful(threads.equals("1"));
        epData.getProperties().put("jobConfig", config);
        return epData;
    }

    protected String[] getProperties(Schedule schedule) throws MuleException {
        ArrayList<String> props = new ArrayList<String>(2);
        if (StringUtils.isNotBlank((String)schedule.cron())) {
            props.add("cronExpression=" + schedule.cron());
        } else if (schedule.interval() > -1L) {
            props.add("repeatInterval=" + schedule.interval());
            if (schedule.startDelay() > -1L) {
                props.add("startDelay=" + schedule.startDelay());
            }
        } else {
            throw new IllegalArgumentException("cron or repeatInterval must be set");
        }
        return (String[])CollectionUtils.toArrayOfComponentType(props, String.class);
    }

    protected String getIdentifier() {
        return Schedule.class.getAnnotation(Channel.class).identifer();
    }

    protected QuartzConnector getConnector() throws MuleException {
        QuartzConnector connector = new QuartzConnector(this.muleContext);
        connector.setName("scheduler." + ((Object)((Object)connector)).hashCode());
        this.muleContext.getRegistry().registerConnector((Connector)connector);
        return connector;
    }

    public boolean supports(Annotation annotation, Class clazz, Member member) {
        return !clazz.isInterface() && super.supports(annotation, clazz, member);
    }
}

