/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.util.List;
import org.mortbay.jetty.plugin.Jetty6MavenConfiguration;
import org.mortbay.jetty.plugin.util.JettyPluginWebApplication;
import org.mortbay.jetty.plus.webapp.EnvConfiguration;
import org.mortbay.jetty.webapp.Configuration;
import org.mortbay.jetty.webapp.JettyWebXmlConfiguration;
import org.mortbay.jetty.webapp.TagLibConfiguration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.jetty.webapp.WebInfConfiguration;

class Jetty6PluginWebApplication
implements JettyPluginWebApplication {
    private WebAppContext context;
    private File webAppDir;
    private File webXmlFile;
    private File overrideWebXmlFile;
    private File jettyEnvXmlFile;
    private List classpathFiles;
    private Configuration[] configurations = new Configuration[]{new WebInfConfiguration(), new EnvConfiguration(), new Jetty6MavenConfiguration(), new JettyWebXmlConfiguration(), new TagLibConfiguration()};

    protected Jetty6PluginWebApplication() {
        this.context = new WebAppContext();
    }

    public void setContextPath(String path) {
        this.context.setContextPath(path);
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public void setWebAppSrcDir(File webAppDir) throws Exception {
        this.webAppDir = webAppDir;
        this.context.setWar(webAppDir.getCanonicalPath());
    }

    public void setTempDirectory(File tmpDir) {
        this.context.setTempDirectory(tmpDir);
        tmpDir.deleteOnExit();
    }

    public void setWebDefaultXmlFile(File webDefaultXml) throws Exception {
        if (webDefaultXml != null) {
            this.context.setDefaultsDescriptor(webDefaultXml.getCanonicalPath());
        }
    }

    public void setOverrideWebXmlFile(File overrideWebXml) throws Exception {
        this.overrideWebXmlFile = overrideWebXml;
        if (overrideWebXml != null) {
            this.context.setOverrideDescriptor(overrideWebXml.getCanonicalPath());
        }
    }

    public void configure() {
        for (int i = 0; i < this.configurations.length; ++i) {
            if (this.configurations[i] instanceof Jetty6MavenConfiguration) {
                ((Jetty6MavenConfiguration)this.configurations[i]).setClassPathConfiguration(this.classpathFiles);
                ((Jetty6MavenConfiguration)this.configurations[i]).setWebXml(this.webXmlFile);
                continue;
            }
            if (!(this.configurations[i] instanceof EnvConfiguration)) continue;
            try {
                if (this.jettyEnvXmlFile == null) continue;
                ((EnvConfiguration)this.configurations[i]).setJettyEnvXml(this.jettyEnvXmlFile.toURL());
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.context.setConfigurations(this.configurations);
    }

    public void setClassPathFiles(List classpathFiles) {
        this.classpathFiles = classpathFiles;
    }

    public void setWebXmlFile(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public void setJettyEnvXmlFile(File jettyEnvXmlFile) {
        this.jettyEnvXmlFile = jettyEnvXmlFile;
    }

    public void start() throws Exception {
        this.context.setShutdown(false);
        this.context.start();
    }

    public void stop() throws Exception {
        this.context.setShutdown(true);
        Thread.currentThread();
        Thread.sleep(500L);
        this.context.stop();
    }

    public Object getProxiedObject() {
        return this.context;
    }
}

