/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.mortbay.jetty.plugin.util.PluginLog;
import org.mortbay.jetty.plus.webapp.Configuration;
import org.mortbay.jetty.webapp.WebAppClassLoader;
import org.mortbay.util.LazyList;

public class Jetty6MavenConfiguration
extends Configuration {
    private List classPathFiles;
    private File webXmlFile;
    private File webAppDir;

    public void setClassPathConfiguration(File webAppDir, List classPathFiles) {
        this.webAppDir = webAppDir;
        this.classPathFiles = classPathFiles;
    }

    public void setWebXml(File webXmlFile) {
        this.webXmlFile = webXmlFile;
    }

    public void configureClassLoader() throws Exception {
        PluginLog.getLog().debug((CharSequence)"Setting up classpath ...");
        Iterator itor = this.classPathFiles.iterator();
        while (itor.hasNext()) {
            ((WebAppClassLoader)this.getWebAppContext().getClassLoader()).addClassPath(((File)itor.next()).getCanonicalPath());
        }
        PluginLog.getLog().info((CharSequence)("Classpath = " + LazyList.array2List((Object[])((URLClassLoader)this.getWebAppContext().getClassLoader()).getURLs())));
    }

    public void configureDefaults() throws Exception {
        super.configureDefaults();
    }

    public void configureWebApp() throws Exception {
        if (this.getWebAppContext().isStarted()) {
            PluginLog.getLog().error((CharSequence)"Cannot configure webapp after it is started");
            return;
        }
        PluginLog.getLog().debug((CharSequence)("Started configuring web.xml, resource base=" + this.webAppDir.getCanonicalPath()));
        this.getWebAppContext().setResourceBase(this.webAppDir.getCanonicalPath());
        if (this.webXmlFile.exists()) {
            this.configure(this.webXmlFile.toURL().toString());
        }
        PluginLog.getLog().debug((CharSequence)"Finished configuring web.xml");
        this.bindUserTransaction();
        this.lockCompEnv();
    }

    public void deconfigureWebApp() throws Exception {
        super.deconfigureWebApp();
    }
}

