/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.jetty.util.Scanner;
import org.mortbay.jetty.plugin.AbstractJettyMojo;

public class JettyRunWarExplodedMojo
extends AbstractJettyMojo {
    private File war;

    public void checkPomConfiguration() throws MojoExecutionException {
    }

    public void configureScanner() throws MojoExecutionException {
        File jettyEnvXmlFile;
        ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(this.getProject().getFile());
        File webInfDir = new File(this.war, "WEB-INF");
        scanList.add(new File(webInfDir, "web.xml"));
        File jettyWebXmlFile = this.findJettyWebXmlFile(webInfDir);
        if (jettyWebXmlFile != null) {
            scanList.add(jettyWebXmlFile);
        }
        if ((jettyEnvXmlFile = new File(webInfDir, "jetty-env.xml")).exists()) {
            scanList.add(jettyEnvXmlFile);
        }
        scanList.add(new File(webInfDir, "classes"));
        scanList.add(new File(webInfDir, "lib"));
        this.setScanList(scanList);
        ArrayList<Scanner.BulkListener> listeners = new ArrayList<Scanner.BulkListener>();
        listeners.add(new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    boolean reconfigure = changes.contains(JettyRunWarExplodedMojo.this.getProject().getFile().getCanonicalPath());
                    JettyRunWarExplodedMojo.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    JettyRunWarExplodedMojo.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)"Restarting webapp");
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.webApp.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        if (reconfigureScanner) {
            File jettyEnvXmlFile;
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            ArrayList<File> scanList = this.getScanList();
            scanList.clear();
            scanList.add(this.getProject().getFile());
            File webInfDir = new File(this.war, "WEB-INF");
            scanList.add(new File(webInfDir, "web.xml"));
            File jettyWebXmlFile = this.findJettyWebXmlFile(webInfDir);
            if (jettyWebXmlFile != null) {
                scanList.add(jettyWebXmlFile);
            }
            if ((jettyEnvXmlFile = new File(webInfDir, "jetty-env.xml")).exists()) {
                scanList.add(jettyEnvXmlFile);
            }
            scanList.add(new File(webInfDir, "classes"));
            scanList.add(new File(webInfDir, "lib"));
            this.setScanList(scanList);
            this.getScanner().setScanDirs(scanList);
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webApp.start();
        this.getLog().info((CharSequence)"Restart completed.");
    }

    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.webApp.setWar(this.war.getCanonicalPath());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }
}

