/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.CatalogAndSchema;
import liquibase.Liquibase;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandExecutionException;
import liquibase.command.CommandFactory;
import liquibase.command.CommandResult;
import liquibase.command.LiquibaseCommand;
import liquibase.command.core.DiffCommand;
import liquibase.database.Database;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.ObjectChangeFilter;
import liquibase.diff.output.StandardObjectChangeFilter;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.plugins.MavenUtils;

public class LiquibaseDatabaseDiff
extends AbstractLiquibaseChangeLogMojo {
    protected String referenceDriver;
    protected String referenceUrl;
    protected String referenceUsername;
    protected String referencePassword;
    protected String referenceDefaultCatalogName;
    protected String referenceDefaultSchemaName;
    protected String diffChangeLogFile;
    protected boolean diffIncludeCatalog;
    protected boolean diffIncludeSchema;
    protected boolean diffIncludeTablespace;
    protected String diffTypes;
    protected String diffExcludeObjects;
    protected String diffIncludeObjects;
    protected String referenceServer;
    protected String schemas;
    protected String referenceSchemas;
    protected String outputSchemas;
    protected String outputFile;
    protected String format;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        AuthenticationInfo referenceInfo;
        if (this.referenceServer != null && (referenceInfo = this.wagonManager.getAuthenticationInfo(this.referenceServer)) != null) {
            this.referenceUsername = referenceInfo.getUserName();
            this.referencePassword = referenceInfo.getPassword();
        }
        super.execute();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        ResourceAccessor resourceAccessor;
        if (this.isFormattedDiff()) {
            if (this.format != null && !this.format.equalsIgnoreCase("json")) {
                String messageString = "\nWARNING: The diff command 'diff --format=" + this.format + "' optional Pro parameter '--format' currently supports only 'TXT' or 'JSON' as values.  (Blank defaults to 'TXT')";
                throw new LiquibaseException(String.format(messageString, new Object[0]));
            }
            boolean hasProLicense = MavenUtils.checkProLicense(this.liquibaseProLicenseKey, this.commandName, this.getLog());
            if (!hasProLicense) {
                throw new LiquibaseException("The command 'diff --format=" + this.format + "' requires a Liquibase Pro License, available at https://www.liquibase.org/download or sales@liquibase.com");
            }
        }
        ClassLoader cl = null;
        try {
            cl = this.getClassLoaderIncludingProjectClasspath();
            Thread.currentThread().setContextClassLoader(cl);
            ClassLoader artifactClassLoader = this.getMavenArtifactClassLoader();
            resourceAccessor = this.getResourceAccessor(artifactClassLoader);
        }
        catch (MojoExecutionException e) {
            throw new LiquibaseException("Could not create the class loader, " + (Object)((Object)e), (Throwable)e);
        }
        Database db = liquibase.getDatabase();
        Database referenceDatabase = CommandLineUtils.createDatabaseObject((ResourceAccessor)resourceAccessor, (String)this.referenceUrl, (String)this.referenceUsername, (String)this.referencePassword, (String)this.referenceDriver, (String)this.referenceDefaultCatalogName, (String)this.referenceDefaultSchemaName, (boolean)this.outputDefaultCatalog, (boolean)this.outputDefaultSchema, null, null, (String)this.propertyProviderClass, null, null, (String)this.databaseChangeLogTableName, (String)this.databaseChangeLogLockTableName);
        this.getLog().info((CharSequence)("Performing Diff on database " + db.toString()));
        if (this.diffExcludeObjects != null && this.diffIncludeObjects != null) {
            throw new UnexpectedLiquibaseException("Cannot specify both excludeObjects and includeObjects");
        }
        StandardObjectChangeFilter objectChangeFilter = null;
        if (this.diffExcludeObjects != null) {
            objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.EXCLUDE, this.diffExcludeObjects);
        }
        if (this.diffIncludeObjects != null) {
            objectChangeFilter = new StandardObjectChangeFilter(StandardObjectChangeFilter.FilterType.INCLUDE, this.diffIncludeObjects);
        }
        CompareControl.SchemaComparison[] schemaComparisons = this.createSchemaComparisons(db);
        if (this.diffChangeLogFile != null) {
            try {
                DiffOutputControl diffOutputControl = new DiffOutputControl(this.diffIncludeCatalog, this.diffIncludeSchema, this.diffIncludeTablespace, null).addIncludedSchema(new CatalogAndSchema(this.referenceDefaultCatalogName, this.referenceDefaultSchemaName));
                diffOutputControl.setObjectChangeFilter((ObjectChangeFilter)objectChangeFilter);
                CommandLineUtils.doDiffToChangeLog((String)this.diffChangeLogFile, (Database)referenceDatabase, (Database)db, (DiffOutputControl)diffOutputControl, (ObjectChangeFilter)objectChangeFilter, (String)StringUtil.trimToNull((String)this.diffTypes), (CompareControl.SchemaComparison[])schemaComparisons);
                if (!new File(this.diffChangeLogFile).exists()) return;
                this.getLog().info((CharSequence)("Differences written to Change Log File, " + this.diffChangeLogFile));
                return;
            }
            catch (IOException | ParserConfigurationException e) {
                throw new LiquibaseException((Throwable)e);
            }
        } else {
            PrintStream printStream = this.createPrintStream();
            if (this.isFormattedDiff()) {
                LiquibaseCommand liquibaseCommand = CommandFactory.getInstance().getCommand("formattedDiff");
                DiffCommand diffCommand = CommandLineUtils.createDiffCommand((Database)referenceDatabase, (Database)db, (String)StringUtil.trimToNull((String)this.diffTypes), (CompareControl.SchemaComparison[])schemaComparisons, (ObjectChangeFilter)objectChangeFilter, (PrintStream)printStream);
                HashMap<String, String> argsMap = new HashMap<String, String>();
                argsMap.put("format", this.format);
                argsMap.put("diffCommand", (String)diffCommand);
                ((AbstractSelfConfiguratingCommand)liquibaseCommand).configure(argsMap);
                try {
                    CommandResult result = liquibaseCommand.execute();
                    if (result.succeeded) return;
                    throw new LiquibaseException(result.message);
                }
                catch (CommandExecutionException cee) {
                    throw new LiquibaseException((Throwable)cee);
                }
            }
            CommandLineUtils.doDiff((Database)referenceDatabase, (Database)db, (String)StringUtil.trimToNull((String)this.diffTypes), (CompareControl.SchemaComparison[])schemaComparisons, (ObjectChangeFilter)objectChangeFilter, (PrintStream)printStream);
        }
    }

    private CompareControl.SchemaComparison[] createSchemaComparisons(Database database) {
        CompareControl.ComputedSchemas computedSchemas = CompareControl.computeSchemas((String)this.schemas, (String)this.referenceSchemas, (String)this.outputSchemas, (String)this.defaultCatalogName, (String)this.defaultSchemaName, (String)this.referenceDefaultCatalogName, (String)this.referenceDefaultSchemaName, (Database)database);
        CompareControl.SchemaComparison[] finalSchemaComparisons = computedSchemas.finalSchemaComparisons;
        return finalSchemaComparisons;
    }

    private PrintStream createPrintStream() throws LiquibaseException {
        try {
            PrintStream printStream = this.outputFile != null ? new PrintStream(this.outputFile) : System.out;
            return printStream;
        }
        catch (FileNotFoundException fnfe) {
            throw new LiquibaseException((Throwable)fnfe);
        }
    }

    private boolean isFormattedDiff() {
        return this.format != null && !this.format.toUpperCase().equals("TXT");
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "referenceDriver: " + this.referenceDriver));
        this.getLog().info((CharSequence)(indent + "referenceUrl: " + this.referenceUrl));
        this.getLog().info((CharSequence)(indent + "referenceUsername: " + this.referenceUsername));
        this.getLog().info((CharSequence)(indent + "referencePassword: " + this.referencePassword));
        this.getLog().info((CharSequence)(indent + "referenceDefaultSchema: " + this.referenceDefaultSchemaName));
        this.getLog().info((CharSequence)(indent + "diffChangeLogFile: " + this.diffChangeLogFile));
    }

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        super.checkRequiredParametersAreSpecified();
        if (this.referenceUrl == null) {
            throw new MojoFailureException("A reference database must be provided to perform a diff.");
        }
        if (this.referencePassword == null) {
            this.referencePassword = "";
        }
    }

    @Override
    protected boolean isPromptOnNonLocalDatabase() {
        return false;
    }
}

