/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.hibernate.snapshot;

import liquibase.exception.DatabaseException;
import liquibase.ext.hibernate.database.HibernateDatabase;
import liquibase.ext.hibernate.snapshot.HibernateSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.SequenceGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;

public class SequenceSnapshotGenerator
extends HibernateSnapshotGenerator {
    public SequenceSnapshotGenerator() {
        super(Sequence.class, new Class[]{Schema.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Sequence.class)) {
            return;
        }
        if (foundObject instanceof Schema) {
            Schema schema = (Schema)foundObject;
            HibernateDatabase database = (HibernateDatabase)snapshot.getDatabase();
            MetadataImplementor metadata = (MetadataImplementor)database.getMetadata();
            for (PersistentClass persistentClass : metadata.getEntityBindings()) {
                SequenceGenerator sequenceGenerator;
                if (persistentClass.isInherited()) continue;
                IdentifierGenerator ig = persistentClass.getIdentifier().createIdentifierGenerator(metadata.getIdentifierGeneratorFactory(), database.getDialect(), null, null, (RootClass)persistentClass);
                if (ig instanceof SequenceGenerator) {
                    sequenceGenerator = (SequenceGenerator)ig;
                    this.createSequence(sequenceGenerator.getSequenceName(), schema);
                    continue;
                }
                if (!(ig instanceof SequenceStyleGenerator)) continue;
                sequenceGenerator = (SequenceStyleGenerator)ig;
                this.createSequence((String)sequenceGenerator.generatorKey(), schema);
            }
        }
    }

    private void createSequence(String sequenceName, Schema schema) {
        Sequence sequence = new Sequence();
        sequence.setName(sequenceName);
        sequence.setSchema(schema);
        schema.addDatabaseObject((DatabaseObject)sequence);
    }
}

