/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.utils;

import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.keycloak.utils.SearchQueryUtils;

public class SearchQueryUtilsTest {
    @Test
    public void testGetFields() {
        this.testParseQuery("   key1:val1 nokey key2:\"val 2\" key3:val3   ", "key1", "val1", "key2", "val 2", "key3", "val3");
        this.testParseQuery("   key1:val1   ", "key1", "val1");
        this.testParseQuery("   key1:\"val1\"   ", "key1", "val1");
        this.testParseQuery("key1:val=\"123456\"", "key1", "val=\"123456\"");
        this.testParseQuery("key1:\"val=\\\"12 34 56\\\"\"", "key1", "val=\"12 34 56\"");
        this.testParseQuery("   \"key 1\":val1", "key 1", "val1");
        this.testParseQuery("\"key \\\"1\\\"\":val1", "key \"1\"", "val1");
        this.testParseQuery("\"key \\\"1\\\"\":\"val \\\"1\\\"\"", "key \"1\"", "val \"1\"");
        this.testParseQuery("key\"1\":val1", "key\"1\"", "val1");
        this.testParseQuery("k:val1", "k", "val1");
    }

    private void testParseQuery(String query, String ... expectedStr) {
        HashMap<String, String> expected = new HashMap<String, String>();
        if (expectedStr != null) {
            if (expectedStr.length % 2 != 0) {
                throw new IllegalArgumentException("Expected must be key-value pairs");
            }
            for (int i = 0; i < expectedStr.length; i += 2) {
                expected.put(expectedStr[i], expectedStr[i + 1]);
            }
        }
        Map actual = SearchQueryUtils.getFields((String)query);
        Assert.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testReDoS() {
        long start = System.currentTimeMillis();
        int count = 50000;
        for (int i = 0; i < count; ++i) {
            SearchQueryUtils.getFields((String)(" ".repeat(1443) + "\n\n".repeat(1443) + "0"));
        }
        long end = System.currentTimeMillis() - start;
        System.out.println("took: " + end + " milliseconds");
    }
}

