/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker.mapper;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.protocol.TestAuthenticatedClientSessionModel;
import org.keycloak.protocol.docker.mapper.AllowAllDockerProtocolMapper;
import org.keycloak.representations.docker.DockerAccess;
import org.keycloak.representations.docker.DockerResponseToken;

public class AllowAllDockerProtocolMapperTest {
    @Test
    public void transformsResourceScope() {
        DockerResponseToken dockerResponseToken = new DockerResponseToken();
        TestAuthenticatedClientSessionModel authenticatedClientSessionModel = new TestAuthenticatedClientSessionModel();
        authenticatedClientSessionModel.setNote("scope", "repository:my-image:pull,push");
        DockerResponseToken result = new AllowAllDockerProtocolMapper().transformDockerResponseToken(dockerResponseToken, new ProtocolMapperModel(), null, null, (AuthenticatedClientSessionModel)authenticatedClientSessionModel);
        MatcherAssert.assertThat((Object)result.getAccessItems(), (Matcher)Matchers.containsInAnyOrder((Object[])new DockerAccess[]{new DockerAccess("repository:my-image:pull,push")}));
    }

    @Test
    public void transformsResourceScopeNull() {
        DockerResponseToken dockerResponseToken = new DockerResponseToken();
        TestAuthenticatedClientSessionModel authenticatedClientSessionModel = new TestAuthenticatedClientSessionModel();
        authenticatedClientSessionModel.setNote("scope", null);
        DockerResponseToken result = new AllowAllDockerProtocolMapper().transformDockerResponseToken(dockerResponseToken, new ProtocolMapperModel(), null, null, (AuthenticatedClientSessionModel)authenticatedClientSessionModel);
        MatcherAssert.assertThat((Object)result.getAccessItems(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[0]));
    }

    @Test
    public void transformsMultipleResourceScopes() {
        DockerResponseToken dockerResponseToken = new DockerResponseToken();
        TestAuthenticatedClientSessionModel authenticatedClientSessionModel = new TestAuthenticatedClientSessionModel();
        authenticatedClientSessionModel.setNote("scope", "repository:my-image:pull,push repository:my-base-image:pull");
        DockerResponseToken result = new AllowAllDockerProtocolMapper().transformDockerResponseToken(dockerResponseToken, new ProtocolMapperModel(), null, null, (AuthenticatedClientSessionModel)authenticatedClientSessionModel);
        MatcherAssert.assertThat((Object)result.getAccessItems(), (Matcher)Matchers.containsInAnyOrder((Object[])new DockerAccess[]{new DockerAccess("repository:my-image:pull,push"), new DockerAccess("repository:my-base-image:pull")}));
    }
}

