/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.consumer;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.VerificationException;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.sdjwt.IssuerSignedJwtVerificationOpts;
import org.keycloak.sdjwt.TestSettings;
import org.keycloak.sdjwt.TestUtils;
import org.keycloak.sdjwt.consumer.PresentationRequirements;
import org.keycloak.sdjwt.consumer.SdJwtPresentationConsumer;
import org.keycloak.sdjwt.consumer.SimplePresentationDefinition;
import org.keycloak.sdjwt.consumer.StaticTrustedSdJwtIssuer;
import org.keycloak.sdjwt.consumer.TrustedSdJwtIssuer;
import org.keycloak.sdjwt.vp.KeyBindingJwtVerificationOpts;
import org.keycloak.sdjwt.vp.SdJwtVP;

public abstract class SdJwtPresentationConsumerTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();
    SdJwtPresentationConsumer sdJwtPresentationConsumer = new SdJwtPresentationConsumer();
    static TestSettings testSettings = TestSettings.getInstance();

    @Test
    public void shouldVerifySdJwtPresentation() throws VerificationException {
        this.sdJwtPresentationConsumer.verifySdJwtPresentation(this.exampleSdJwtVP(), this.examplePresentationRequirements(), this.exampleTrustedSdJwtIssuers(), this.defaultIssuerSignedJwtVerificationOpts(), this.defaultKeyBindingJwtVerificationOpts());
    }

    @Test
    public void shouldFail_IfPresentationRequirementsNotMet() {
        SimplePresentationDefinition definition = SimplePresentationDefinition.builder().addClaimRequirement("vct", ".*diploma.*").build();
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> this.sdJwtPresentationConsumer.verifySdJwtPresentation(this.exampleSdJwtVP(), (PresentationRequirements)definition, this.exampleTrustedSdJwtIssuers(), this.defaultIssuerSignedJwtVerificationOpts(), this.defaultKeyBindingJwtVerificationOpts()));
        Assert.assertTrue((boolean)exception.getMessage().contains("A required field was not presented: `vct`"));
    }

    private SdJwtVP exampleSdJwtVP() {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), "sdjwt/s20.1-sdjwt+kb.txt");
        return SdJwtVP.of((String)sdJwtVPString);
    }

    private PresentationRequirements examplePresentationRequirements() {
        return SimplePresentationDefinition.builder().addClaimRequirement("sub", "\"user_[0-9]+\"").addClaimRequirement("given_name", ".*").build();
    }

    private List<TrustedSdJwtIssuer> exampleTrustedSdJwtIssuers() {
        return Arrays.asList(new StaticTrustedSdJwtIssuer(Collections.singletonList(SdJwtPresentationConsumerTest.testSettings.holderVerifierContext)), new StaticTrustedSdJwtIssuer(Collections.singletonList(SdJwtPresentationConsumerTest.testSettings.issuerVerifierContext)));
    }

    private IssuerSignedJwtVerificationOpts defaultIssuerSignedJwtVerificationOpts() {
        return IssuerSignedJwtVerificationOpts.builder().withValidateIssuedAtClaim(false).withValidateNotBeforeClaim(false).build();
    }

    private KeyBindingJwtVerificationOpts defaultKeyBindingJwtVerificationOpts() {
        return KeyBindingJwtVerificationOpts.builder().withKeyBindingRequired(true).withAllowedMaxAge(Integer.MAX_VALUE).withNonce("1234567890").withAud("https://verifier.example.org").withValidateExpirationClaim(false).withValidateNotBeforeClaim(false).build();
    }
}

