/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt.consumer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.rmi.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.rule.CryptoInitRule;
import org.keycloak.sdjwt.IssuerSignedJWT;
import org.keycloak.sdjwt.SdJwtUtils;
import org.keycloak.sdjwt.TestUtils;
import org.keycloak.sdjwt.consumer.HttpDataFetcher;
import org.keycloak.sdjwt.consumer.JwtVcMetadataTrustedSdJwtIssuer;
import org.keycloak.sdjwt.consumer.TrustedSdJwtIssuer;
import org.keycloak.sdjwt.vp.SdJwtVP;

public abstract class JwtVcMetadataTrustedSdJwtIssuerTest {
    @ClassRule
    public static CryptoInitRule cryptoInitRule = new CryptoInitRule();

    @Test
    public void shouldResolveIssuerVerifyingKeys() throws Exception {
        String issuerUri = "https://issuer.example.com";
        JwtVcMetadataTrustedSdJwtIssuer trustedIssuer = new JwtVcMetadataTrustedSdJwtIssuer(issuerUri, this.mockHttpDataFetcher());
        IssuerSignedJWT issuerSignedJWT = this.exampleIssuerSignedJwt();
        List keys = trustedIssuer.resolveIssuerVerifyingKeys(issuerSignedJWT);
        Assert.assertEquals((long)3L, (long)keys.size());
    }

    @Test
    public void shouldResolveKeys_WhenIssuerTrustedOnRegexPattern() throws Exception {
        Pattern issuerUriRegex = Pattern.compile("https://.*\\.example\\.com");
        JwtVcMetadataTrustedSdJwtIssuer trustedIssuer = new JwtVcMetadataTrustedSdJwtIssuer(issuerUriRegex, this.mockHttpDataFetcher());
        IssuerSignedJWT issuerSignedJWT = this.exampleIssuerSignedJwt();
        trustedIssuer.resolveIssuerVerifyingKeys(issuerSignedJWT);
    }

    @Test
    public void shouldResolveKeys_WhenJwtSpecifiesKid() throws VerificationException, JsonProcessingException {
        String issuerUri = "https://issuer.example.com";
        JwtVcMetadataTrustedSdJwtIssuer trustedIssuer = new JwtVcMetadataTrustedSdJwtIssuer(issuerUri, this.mockHttpDataFetcher());
        IssuerSignedJWT issuerSignedJWT = this.exampleIssuerSignedJwt("sdjwt/s20.1-sdjwt+kb--explicit-kid.txt");
        List keys = trustedIssuer.resolveIssuerVerifyingKeys(issuerSignedJWT);
        Assert.assertEquals((long)1L, (long)keys.size());
        Assert.assertEquals((Object)"doc-signer-05-25-2022", (Object)((SignatureVerifierContext)keys.get(0)).getKid());
    }

    @Test
    public void shouldRejectNonHttpsIssuerURIs() {
        String issuerUri = "http://issuer.example.com";
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> new JwtVcMetadataTrustedSdJwtIssuer(issuerUri, this.mockHttpDataFetcher()));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.endsWith((String)"HTTPS URI required to retrieve JWT VC Issuer Metadata"));
    }

    @Test
    public void shouldRejectNonHttpsIssuerURIs_EvenIfIssuerBuiltWithRegexPattern() throws JsonProcessingException {
        Pattern issuerUriRegex = Pattern.compile(".*\\.example\\.com");
        JwtVcMetadataTrustedSdJwtIssuer trustedIssuer = new JwtVcMetadataTrustedSdJwtIssuer(issuerUriRegex, this.mockHttpDataFetcher());
        String issuerUri = "http://issuer.example.com";
        IssuerSignedJWT issuerSignedJWT = this.exampleIssuerSignedJwtWithIssuer(issuerUri);
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> JwtVcMetadataTrustedSdJwtIssuerTest.lambda$shouldRejectNonHttpsIssuerURIs_EvenIfIssuerBuiltWithRegexPattern$1((TrustedSdJwtIssuer)trustedIssuer, issuerSignedJWT));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.endsWith((String)"HTTPS URI required to retrieve JWT VC Issuer Metadata"));
    }

    @Test
    public void shouldRejectJwtsWithUnexpectedIssuerClaims() throws JsonProcessingException {
        String regex = "https://.*\\.example\\.com";
        Pattern issuerUriRegex = Pattern.compile(regex);
        JwtVcMetadataTrustedSdJwtIssuer trustedIssuer = new JwtVcMetadataTrustedSdJwtIssuer(issuerUriRegex, this.mockHttpDataFetcher());
        String issuerUri = "https://trial.authlete.com";
        IssuerSignedJWT issuerSignedJWT = this.exampleIssuerSignedJwtWithIssuer(issuerUri);
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> JwtVcMetadataTrustedSdJwtIssuerTest.lambda$shouldRejectJwtsWithUnexpectedIssuerClaims$2((TrustedSdJwtIssuer)trustedIssuer, issuerSignedJWT));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.endsWith((String)String.format("Unexpected Issuer URI claim. Expected=/%s/, Got=%s", regex, issuerUri)));
    }

    @Test
    public void shouldFailOnInvalidJwkExposed() throws JsonProcessingException {
        String issuerUri = "https://issuer.example.com";
        ObjectNode metadata = SdJwtUtils.mapper.createObjectNode();
        metadata.put("issuer", issuerUri);
        metadata.set("jwks", SdJwtUtils.mapper.readTree("{\n  \"keys\": [\n    {\n      \"kty\": \"EC\",\n      \"x\": \"invalid\",\n      \"y\": \"invalid\"\n    }\n  ]\n}"));
        this.genericTestShouldFail(this.exampleIssuerSignedJwt(), this.mockHttpDataFetcherWithMetadata(issuerUri, (JsonNode)metadata), "A potential JWK was retrieved but found invalid", "Unsupported or invalid JWK");
    }

    @Test
    public void shouldFailOnUnexpectedIssuerExposed() throws JsonProcessingException {
        String issuerUri = "https://issuer.example.com";
        ObjectNode metadata = SdJwtUtils.mapper.createObjectNode();
        metadata.put("issuer", "https://another-issuer.example.com");
        this.genericTestShouldFail(this.exampleIssuerSignedJwt(), this.mockHttpDataFetcherWithMetadata(issuerUri, (JsonNode)metadata), "Unexpected metadata's issuer", null);
    }

    @Test
    public void shouldFailOnMalformedJwtVcMetadataExposed() throws JsonProcessingException {
        String issuerUri = "https://issuer.example.com";
        ObjectNode metadata = SdJwtUtils.mapper.createObjectNode();
        metadata.set("issuer", SdJwtUtils.mapper.readTree("{}"));
        this.genericTestShouldFail(this.exampleIssuerSignedJwt(), this.mockHttpDataFetcherWithMetadata(issuerUri, (JsonNode)metadata), "Failed to parse exposed JWT VC Metadata", null);
    }

    @Test
    public void shouldFailOnMalformedJwksExposed() throws JsonProcessingException {
        List<JsonNode> malformedJwks = Arrays.asList(SdJwtUtils.mapper.readTree("[]"), SdJwtUtils.mapper.readTree("{\"keys\": {}}"));
        for (JsonNode jwks : malformedJwks) {
            String issuerUri = "https://issuer.example.com";
            ObjectNode metadata = SdJwtUtils.mapper.createObjectNode();
            metadata.put("issuer", issuerUri);
            metadata.put("jwks_uri", "https://issuer.example.com/api/vci/jwks");
            this.genericTestShouldFail(this.exampleIssuerSignedJwt(), this.mockHttpDataFetcherWithMetadataAndJwks(issuerUri, (JsonNode)metadata, jwks), "Failed to parse exposed JWKS", null);
        }
    }

    @Test
    public void shouldFailOnMissingJwksOnMetadataEndpoint() throws JsonProcessingException {
        String issuerUri = "https://issuer.example.com";
        ObjectNode metadata = SdJwtUtils.mapper.createObjectNode();
        metadata.put("issuer", issuerUri);
        this.genericTestShouldFail(this.exampleIssuerSignedJwt(), this.mockHttpDataFetcherWithMetadata(issuerUri, (JsonNode)metadata), String.format("Could not resolve issuer JWKs with URI: %s", issuerUri), null);
    }

    @Test
    public void shouldFailOnEmptyPublishedJwkList() throws Exception {
        JsonNode jwks = SdJwtUtils.mapper.readTree("{\"keys\": []}");
        String issuerUri = "https://issuer.example.com";
        ObjectNode metadata = SdJwtUtils.mapper.createObjectNode();
        metadata.put("issuer", issuerUri);
        metadata.set("jwks", jwks);
        this.genericTestShouldFail(this.exampleIssuerSignedJwt(), this.mockHttpDataFetcherWithMetadataAndJwks(issuerUri, (JsonNode)metadata, jwks), String.format("Issuer JWKs were unexpectedly resolved to an empty list. Issuer URI: %s", issuerUri), null);
    }

    @Test
    public void shouldFailOnNoPublishedJwkMatchingJwtKid() throws Exception {
        JsonNode jwks = this.exampleJwks();
        for (JsonNode jwk : jwks.get("keys")) {
            ((ObjectNode)jwk).put("kid", jwk.get("kid").asText() + "-wont-match");
        }
        String issuerUri = "https://issuer.example.com";
        ObjectNode metadata = SdJwtUtils.mapper.createObjectNode();
        metadata.put("issuer", issuerUri);
        metadata.set("jwks", jwks);
        IssuerSignedJWT issuerSignedJWT = this.exampleIssuerSignedJwt("sdjwt/s20.1-sdjwt+kb--explicit-kid.txt");
        String kid = issuerSignedJWT.getHeader().getKeyId();
        this.genericTestShouldFail(issuerSignedJWT, this.mockHttpDataFetcherWithMetadataAndJwks(issuerUri, (JsonNode)metadata, jwks), String.format("No published JWK was found to match kid: %s", kid), null);
    }

    @Test
    public void shouldFailOnPublishedJwksWithDuplicateKid() throws JsonProcessingException {
        IssuerSignedJWT issuerSignedJWT = this.exampleIssuerSignedJwt("sdjwt/s20.1-sdjwt+kb--explicit-kid.txt");
        String kid = issuerSignedJWT.getHeader().getKeyId();
        JsonNode jwks = this.exampleJwks();
        for (JsonNode jwk : jwks.get("keys")) {
            ((ObjectNode)jwk).put("kid", kid);
        }
        String issuerUri = "https://issuer.example.com";
        ObjectNode metadata = SdJwtUtils.mapper.createObjectNode();
        metadata.put("issuer", issuerUri);
        metadata.set("jwks", jwks);
        JwtVcMetadataTrustedSdJwtIssuer trustedIssuer = new JwtVcMetadataTrustedSdJwtIssuer(issuerUri, this.mockHttpDataFetcherWithMetadata(issuerUri, (JsonNode)metadata));
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> JwtVcMetadataTrustedSdJwtIssuerTest.lambda$shouldFailOnPublishedJwksWithDuplicateKid$3((TrustedSdJwtIssuer)trustedIssuer, issuerSignedJWT));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)CoreMatchers.endsWith((String)String.format("Cannot choose between multiple exposed JWKs with same kid: %s", kid)));
    }

    @Test
    public void shouldFailOnIOErrorWhileFetchingMetadata() throws JsonProcessingException {
        String issuerUri = "https://issuer.example.com";
        ObjectNode metadata = SdJwtUtils.mapper.createObjectNode();
        metadata.put("issuer", issuerUri);
        HttpDataFetcher mockFetcher = this.mockHttpDataFetcherWithMetadata("https://another-issuer.example.com", (JsonNode)metadata);
        this.genericTestShouldFail(this.exampleIssuerSignedJwt(), mockFetcher, String.format("Could not fetch data from URI: %s", issuerUri), null);
    }

    private void genericTestShouldFail(IssuerSignedJWT issuerSignedJWT, HttpDataFetcher mockFetcher, String errorMessage, String causeErrorMessage) {
        JwtVcMetadataTrustedSdJwtIssuer trustedIssuer = new JwtVcMetadataTrustedSdJwtIssuer(issuerSignedJWT.getPayload().get("iss").asText(), mockFetcher);
        VerificationException exception = (VerificationException)Assert.assertThrows(VerificationException.class, () -> JwtVcMetadataTrustedSdJwtIssuerTest.lambda$genericTestShouldFail$4((TrustedSdJwtIssuer)trustedIssuer, issuerSignedJWT));
        Assert.assertTrue((boolean)exception.getMessage().contains(errorMessage));
        if (causeErrorMessage != null) {
            Assert.assertTrue((boolean)exception.getCause().getMessage().contains(causeErrorMessage));
        }
    }

    private IssuerSignedJWT exampleIssuerSignedJwt() {
        return this.exampleIssuerSignedJwt("sdjwt/s20.1-sdjwt+kb.txt");
    }

    private IssuerSignedJWT exampleIssuerSignedJwt(String sdJwtVector) {
        return this.exampleIssuerSignedJwt(sdJwtVector, "https://issuer.example.com");
    }

    private IssuerSignedJWT exampleIssuerSignedJwtWithIssuer(String issuerUri) {
        return this.exampleIssuerSignedJwt("sdjwt/s20.1-sdjwt+kb.txt", issuerUri);
    }

    private IssuerSignedJWT exampleIssuerSignedJwt(String sdJwtVector, String issuerUri) {
        String sdJwtVPString = TestUtils.readFileAsString(this.getClass(), sdJwtVector);
        IssuerSignedJWT issuerSignedJWT = SdJwtVP.of((String)sdJwtVPString).getIssuerSignedJWT();
        ((ObjectNode)issuerSignedJWT.getPayload()).put("iss", issuerUri);
        return issuerSignedJWT;
    }

    private JsonNode exampleJwks() throws JsonProcessingException {
        return SdJwtUtils.mapper.readTree(TestUtils.readFileAsString(this.getClass(), "sdjwt/s30.1-jwt-vc-metadata-jwks.json"));
    }

    private HttpDataFetcher mockHttpDataFetcher() throws JsonProcessingException {
        ObjectNode metadata = SdJwtUtils.mapper.createObjectNode();
        metadata.put("issuer", "https://issuer.example.com");
        metadata.put("jwks_uri", "https://issuer.example.com/api/vci/jwks");
        return this.mockHttpDataFetcherWithMetadata(metadata.get("issuer").asText(), (JsonNode)metadata);
    }

    private HttpDataFetcher mockHttpDataFetcherWithMetadata(String issuer, JsonNode metadata) throws JsonProcessingException {
        return this.mockHttpDataFetcherWithMetadataAndJwks(issuer, metadata, this.exampleJwks());
    }

    private HttpDataFetcher mockHttpDataFetcherWithMetadataAndJwks(String issuer, JsonNode metadata, JsonNode jwks) {
        return uri -> {
            if (!uri.startsWith(issuer)) {
                throw new UnknownHostException("Unavailable URI");
            }
            if (uri.endsWith("/.well-known/jwt-vc-issuer")) {
                return metadata;
            }
            if (uri.endsWith("/api/vci/jwks")) {
                return jwks;
            }
            throw new UnknownHostException("Unavailable URI");
        };
    }

    private static /* synthetic */ void lambda$genericTestShouldFail$4(TrustedSdJwtIssuer trustedIssuer, IssuerSignedJWT issuerSignedJWT) throws Throwable {
        trustedIssuer.resolveIssuerVerifyingKeys(issuerSignedJWT);
    }

    private static /* synthetic */ void lambda$shouldFailOnPublishedJwksWithDuplicateKid$3(TrustedSdJwtIssuer trustedIssuer, IssuerSignedJWT issuerSignedJWT) throws Throwable {
        trustedIssuer.resolveIssuerVerifyingKeys(issuerSignedJWT);
    }

    private static /* synthetic */ void lambda$shouldRejectJwtsWithUnexpectedIssuerClaims$2(TrustedSdJwtIssuer trustedIssuer, IssuerSignedJWT issuerSignedJWT) throws Throwable {
        trustedIssuer.resolveIssuerVerifyingKeys(issuerSignedJWT);
    }

    private static /* synthetic */ void lambda$shouldRejectNonHttpsIssuerURIs_EvenIfIssuerBuiltWithRegexPattern$1(TrustedSdJwtIssuer trustedIssuer, IssuerSignedJWT issuerSignedJWT) throws Throwable {
        trustedIssuer.resolveIssuerVerifyingKeys(issuerSignedJWT);
    }
}

