/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;

class HierarchicalOutputDirectoryProvider
implements OutputDirectoryProvider {
    private static final Pattern FORBIDDEN_CHARS = Pattern.compile("[^a-z0-9.,_\\-() ]", 2);
    private static final String REPLACEMENT = "_";
    private final Supplier<Path> rootDirSupplier;
    private volatile Path rootDir;

    HierarchicalOutputDirectoryProvider(Supplier<Path> rootDirSupplier) {
        this.rootDirSupplier = rootDirSupplier;
    }

    public Path createOutputDirectory(TestDescriptor testDescriptor) throws IOException {
        Preconditions.notNull((Object)testDescriptor, (String)"testDescriptor must not be null");
        List segments = testDescriptor.getUniqueId().getSegments();
        Path relativePath = segments.stream().skip(1L).map(HierarchicalOutputDirectoryProvider::toSanitizedPath).reduce(HierarchicalOutputDirectoryProvider.toSanitizedPath((UniqueId.Segment)segments.get(0)), Path::resolve);
        return Files.createDirectories(this.getRootDirectory().resolve(relativePath), new FileAttribute[0]);
    }

    public synchronized Path getRootDirectory() {
        if (this.rootDir == null) {
            this.rootDir = this.rootDirSupplier.get();
        }
        return this.rootDir;
    }

    private static Path toSanitizedPath(UniqueId.Segment segment) {
        return Paths.get(HierarchicalOutputDirectoryProvider.sanitizeName(segment.getValue()), new String[0]);
    }

    private static String sanitizeName(String value) {
        return FORBIDDEN_CHARS.matcher(value).replaceAll(REPLACEMENT);
    }
}

