/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.CoroutineInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeTemplate;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0003H\u0002\u001a\f\u0010\r\u001a\u00020\u0001*\u00020\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u0006\u0012\u0002\b\u00030\u0011H\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0011\u00a8\u0006\u0013"}, d2={"isApplicableCallForBuilderInference", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "isCoroutineCallWithAdditionalInference", "parameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "argument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "isGoodCallForOldCoroutines", "resultingDescriptor", "containsTypeTemplate", "Lorg/jetbrains/kotlin/types/KotlinType;", "getCoroutineInferenceData", "Lorg/jetbrains/kotlin/resolve/calls/inference/CoroutineInferenceData;", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "isResultWithCoroutineInference", "frontend"})
public final class CoroutineInferenceUtilKt {
    private static final boolean containsTypeTemplate(KotlinType $this$containsTypeTemplate) {
        return TypeUtilsKt.contains($this$containsTypeTemplate, (Function1<? super UnwrappedType, Boolean>)((Function1)containsTypeTemplate.1.INSTANCE));
    }

    public static final boolean isApplicableCallForBuilderInference(@NotNull CallableDescriptor descriptor2, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (!languageVersionSettings.supportsFeature(LanguageFeature.ExperimentalBuilderInference)) {
            return CoroutineInferenceUtilKt.isGoodCallForOldCoroutines(descriptor2);
        }
        if (DescriptorUtilsKt.isExtension(descriptor2) && !AnnotationsForResolveUtilsKt.hasBuilderInferenceAnnotation(descriptor2)) {
            KotlinType kotlinType;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            return Intrinsics.areEqual(receiverParameterDescriptor == null ? null : ((kotlinType = receiverParameterDescriptor.getType()) == null ? null : Boolean.valueOf(CoroutineInferenceUtilKt.containsTypeTemplate(kotlinType))), (Object)false);
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType kotlinType2 = kotlinType;
        KotlinType returnType2 = kotlinType2;
        return !CoroutineInferenceUtilKt.containsTypeTemplate(returnType2);
    }

    private static final boolean isGoodCallForOldCoroutines(CallableDescriptor resultingDescriptor) {
        boolean bl;
        block6: {
            KotlinType kotlinType = resultingDescriptor.getReturnType();
            if (kotlinType == null) {
                return false;
            }
            Object object = kotlinType;
            Object returnType2 = object;
            if (CoroutineInferenceUtilKt.containsTypeTemplate((KotlinType)returnType2)) {
                return false;
            }
            if (!(resultingDescriptor instanceof FunctionDescriptor) || ((FunctionDescriptor)resultingDescriptor).isSuspend()) {
                return true;
            }
            object = ((FunctionDescriptor)resultingDescriptor).getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resultingDescriptor.valueParameters");
            Iterable $this$any$iv = (Iterable)object;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    KotlinType kotlinType2 = it.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"it.type");
                    if (!CoroutineInferenceUtilKt.containsTypeTemplate(kotlinType2)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return !bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCoroutineCallWithAdditionalInference(@NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ValueArgument argument2, @NotNull LanguageVersionSettings languageVersionSettings) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parameterDescriptor, (String)"parameterDescriptor");
        Intrinsics.checkNotNullParameter((Object)argument2, (String)"argument");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        if (languageVersionSettings.supportsFeature(LanguageFeature.ExperimentalBuilderInference)) {
            if (!AnnotationsForResolveUtilsKt.hasBuilderInferenceAnnotation(parameterDescriptor)) return false;
            if (!CoroutineUtilKt.getHasFunctionOrSuspendFunctionType(parameterDescriptor)) return false;
            bl = true;
        } else {
            bl = CoroutineUtilKt.getHasSuspendFunctionType(parameterDescriptor);
        }
        boolean parameterHasOptIn = bl;
        if (!parameterHasOptIn) return false;
        if (!(argument2.getArgumentExpression() instanceof KtLambdaExpression)) return false;
        KotlinType kotlinType = parameterDescriptor.getType();
        boolean bl2 = false;
        boolean bl3 = false;
        KotlinType it = kotlinType;
        boolean bl4 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (!FunctionTypesKt.isBuiltinFunctionalType(it)) return false;
        if (FunctionTypesKt.getReceiverTypeFromFunctionType(it) == null) return false;
        return true;
    }

    public static final boolean isResultWithCoroutineInference(@NotNull OverloadResolutionResultsImpl<?> $this$isResultWithCoroutineInference) {
        Intrinsics.checkNotNullParameter($this$isResultWithCoroutineInference, (String)"<this>");
        return CoroutineInferenceUtilKt.getCoroutineInferenceData($this$isResultWithCoroutineInference) != null;
    }

    private static final CoroutineInferenceData getCoroutineInferenceData(OverloadResolutionResultsImpl<?> $this$getCoroutineInferenceData) {
        if (!$this$getCoroutineInferenceData.isSingleResult()) {
            return null;
        }
        CoroutineInferenceData coroutineInferenceData = CoroutineInferenceUtilKt.getCoroutineInferenceData$getData($this$getCoroutineInferenceData.getResultingCall().getDispatchReceiver());
        return coroutineInferenceData == null ? CoroutineInferenceUtilKt.getCoroutineInferenceData$getData($this$getCoroutineInferenceData.getResultingCall().getExtensionReceiver()) : coroutineInferenceData;
    }

    private static final CoroutineInferenceData getCoroutineInferenceData$getData(ReceiverValue receiverValue) {
        KotlinType kotlinType;
        Ref.ObjectRef coroutineInferenceData = new Ref.ObjectRef();
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 != null && (kotlinType = receiverValue2.getType()) != null) {
            TypeUtilsKt.contains(kotlinType, (Function1<? super UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>((Ref.ObjectRef<CoroutineInferenceData>)coroutineInferenceData){
                final /* synthetic */ Ref.ObjectRef<CoroutineInferenceData> $coroutineInferenceData;
                {
                    this.$coroutineInferenceData = $coroutineInferenceData;
                    super(1);
                }

                public final boolean invoke(@NotNull UnwrappedType it) {
                    TypeTemplate typeTemplate;
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    TypeTemplate typeTemplate2 = typeTemplate = it instanceof TypeTemplate ? (TypeTemplate)it : null;
                    if (typeTemplate != null) {
                        CoroutineInferenceData coroutineInferenceData;
                        CoroutineInferenceData coroutineInferenceData2 = coroutineInferenceData = typeTemplate.getCoroutineInferenceData();
                        Ref.ObjectRef<CoroutineInferenceData> objectRef = this.$coroutineInferenceData;
                        boolean bl = false;
                        boolean bl2 = false;
                        CoroutineInferenceData it2 = coroutineInferenceData2;
                        boolean bl3 = false;
                        objectRef.element = it2;
                    }
                    return false;
                }
            }));
        }
        return (CoroutineInferenceData)coroutineInferenceData.element;
    }

    public static final /* synthetic */ CoroutineInferenceData access$getCoroutineInferenceData(OverloadResolutionResultsImpl $receiver) {
        return CoroutineInferenceUtilKt.getCoroutineInferenceData($receiver);
    }
}

