/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.cache.internal;

final class DoubleLinkedList<K, V> {
    final Node<K, V> rootNode = DoubleLinkedList.createNode(null, null);
    int size = 0;

    DoubleLinkedList() {
        this.rootNode.right = this.rootNode;
        this.rootNode.left = this.rootNode;
    }

    void addHead(Node<K, V> node) {
        if (node == null) {
            return;
        }
        if (node.left != null || node.right != null) {
            throw new IllegalStateException("Can not add node twice!");
        }
        node.left = this.rootNode;
        node.right = this.rootNode.right;
        node.left.right = node;
        node.right.left = node;
        ++this.size;
    }

    Node<K, V> removeTail() {
        return this.removeNode(this.rootNode.left);
    }

    Node<K, V> removeNode(Node<K, V> node) {
        if (node == this.rootNode || node.left == null || node.right == null) {
            return null;
        }
        node.left.right = node.right;
        node.right.left = node.left;
        node.left = null;
        node.right = null;
        --this.size;
        return node;
    }

    static <K, V> Node<K, V> createNode(K key, V value) {
        return new Node<K, V>(key, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        Node node = this.rootNode.right;
        while (node != null && node != this.rootNode) {
            sb.append(node.key).append(" = ").append(node.value);
            if (node.right != null) {
                sb.append(", ");
            }
            node = node.right;
        }
        sb.append(']');
        return sb.toString();
    }

    static final class Node<K, V> {
        Node<K, V> left = null;
        Node<K, V> right = null;
        final K key;
        final V value;

        private Node(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

