/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.plain;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import org.jboss.sasl.callback.VerifyPasswordCallback;
import org.jboss.sasl.util.AbstractSaslParticipant;
import org.jboss.sasl.util.AbstractSaslServer;
import org.jboss.sasl.util.Charsets;
import org.jboss.sasl.util.SaslState;
import org.jboss.sasl.util.SaslStateContext;

public final class PlainSaslServer
extends AbstractSaslServer {
    protected String authorizedId;
    private final SaslState INITIAL = new SaslState(){
        private static final byte UTF8NUL = 0;
        private static final int MAX_DEPTH = 2;

        @Override
        public byte[] evaluateMessage(SaslStateContext context, byte[] message) throws SaslException {
            String passwd;
            String authzid;
            String authcid;
            int length = message.length;
            if (length == 0) {
                return AbstractSaslParticipant.NO_BYTES;
            }
            if (length > 1020) {
                throw new SaslException("Authentication name string is too long");
            }
            String[] parts = this.split(message);
            if (parts.length == 2) {
                authzid = authcid = parts[0];
                passwd = parts[1];
            } else if (parts.length == 3) {
                authzid = parts[0];
                authcid = parts[1];
                passwd = parts[2];
            } else {
                throw new SaslException("Invalid number of message parts (" + parts.length + ")");
            }
            if (authcid.length() > 255) {
                throw new SaslException("Authentication identity string is too long");
            }
            if (authzid.length() > 255) {
                throw new SaslException("Authorization identity string is too long");
            }
            if (passwd.length() > 255) {
                throw new SaslException("Password string is too long");
            }
            NameCallback ncb = new NameCallback("PLAIN authentication identity", authcid);
            VerifyPasswordCallback vpc = new VerifyPasswordCallback(passwd);
            PlainSaslServer.this.handleCallbacks(new Callback[]{ncb, vpc});
            if (!vpc.isVerified()) {
                throw new SaslException("PLAIN password not verified by CallbackHandler");
            }
            AuthorizeCallback acb = new AuthorizeCallback(authcid, authzid);
            PlainSaslServer.this.handleCallbacks(new Callback[]{acb});
            if (!acb.isAuthorized()) {
                throw new SaslException("PLAIN: " + authcid + " is not authorized to act as " + authzid);
            }
            PlainSaslServer.this.authorizedId = acb.getAuthorizedID();
            context.negotiationComplete();
            return null;
        }

        private String[] split(byte[] message) throws SaslException {
            return this.split(message, 0, 0);
        }

        private String[] split(byte[] message, int startPos, int depth) throws SaslException {
            if (depth > 2) {
                throw new SaslException("PLAIN: Invalid message format. (Too many delimiters)");
            }
            int nulpos = -1;
            for (int i = startPos; i < message.length && nulpos < 0; ++i) {
                if (message[i] != 0) continue;
                nulpos = i;
            }
            int length = nulpos < 0 ? message.length - startPos : nulpos - startPos;
            String part = new String(message, startPos, length, Charsets.UTF_8);
            String[] response = nulpos < 0 ? new String[depth + 1] : this.split(message, nulpos + 1, depth + 1);
            response[depth] = part;
            return response;
        }
    };

    public PlainSaslServer(String protocol, String serverName, CallbackHandler callbackHandler) {
        super("PLAIN", protocol, serverName, callbackHandler);
        this.getContext().setNegotiationState(this.INITIAL);
    }

    @Override
    public String getAuthorizationID() {
        if (this.isComplete()) {
            return this.authorizedId;
        }
        throw new IllegalStateException("PLAIN server negotiation not complete");
    }
}

