/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.anonymous;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.SaslException;
import org.jboss.sasl.util.AbstractSaslClient;
import org.jboss.sasl.util.AbstractSaslParticipant;
import org.jboss.sasl.util.Charsets;
import org.jboss.sasl.util.SaslState;
import org.jboss.sasl.util.SaslStateContext;

public final class AnonymousSaslClient
extends AbstractSaslClient {
    private final SaslState initial = new SaslState(){

        @Override
        public byte[] evaluateMessage(SaslStateContext context, byte[] message) throws SaslException {
            if (message != null && message.length > 0) {
                throw new SaslException("Invalid challenge received from server");
            }
            NameCallback nameCallback = new NameCallback("Authentication name");
            AnonymousSaslClient.this.handleCallbacks(new Callback[]{nameCallback});
            String name = nameCallback.getName();
            if (name == null) {
                throw new SaslException("Authentication name is missing");
            }
            if (name.length() > 255) {
                throw new SaslException("Authentication name string is too long");
            }
            if (name.isEmpty()) {
                throw new SaslException("Authentication name is empty");
            }
            context.negotiationComplete();
            return name == null ? AbstractSaslParticipant.NO_BYTES : name.getBytes(Charsets.UTF_8);
        }
    };

    protected AnonymousSaslClient(String protocol, String serverName, CallbackHandler callbackHandler, String authorizationId) {
        super("ANONYMOUS", protocol, serverName, callbackHandler, authorizationId, false);
        this.getContext().setNegotiationState(this.initial);
    }
}

