/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.tracing;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Configuration;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.tracing.api.RESTEasyTracing;
import org.jboss.resteasy.tracing.api.RESTEasyTracingConfig;
import org.jboss.resteasy.tracing.api.RESTEasyTracingLevel;

public class RESTEasyTracingUtils {
    static final List<String> SUMMARY_HEADERS = new ArrayList<String>();

    private RESTEasyTracingUtils() {
    }

    static String getTracingThreshold(RESTEasyTracingLevel appThreshold, HttpRequest request) {
        String thresholdText = RESTEasyTracingUtils.getHeaderString(request, "X-RESTEasy-Tracing-Threshold");
        return thresholdText == null ? appThreshold.toString() : thresholdText;
    }

    static String getHeaderString(HttpRequest request, String header) {
        if (request == null) {
            return null;
        }
        if (request.getHttpHeaders() != null) {
            return request.getHttpHeaders().getHeaderString(header);
        }
        return null;
    }

    static String toStringOrNA(Object object) {
        if (object == null) {
            return "n/a";
        }
        return String.valueOf(object);
    }

    static boolean isTracingSupportEnabled(RESTEasyTracingConfig type, HttpRequest request) {
        return type == RESTEasyTracingConfig.ALL || type == RESTEasyTracingConfig.ON_DEMAND && RESTEasyTracingUtils.getHeaderString(request, "X-RESTEasy-Tracing-Accept") != null;
    }

    static RESTEasyTracingConfig getRESTEasyTracingConfig(Configuration configuration) {
        Object tracingText = configuration.getProperty("resteasy.server.tracing.type");
        RESTEasyTracingConfig result = tracingText != null ? RESTEasyTracingConfig.valueOf((String)((String)tracingText)) : RESTEasyTracingConfig.OFF;
        return result;
    }

    static String getTracingLoggerNameSuffix(HttpRequest request) {
        return RESTEasyTracingUtils.getHeaderString(request, "X-RESTEasy-Tracing-Logger");
    }

    static RESTEasyTracingLevel getRESTEasyTracingThreshold(Configuration configuration) {
        Object thresholdText = configuration.getProperty("resteasy.server.tracing.threshold");
        return thresholdText == null ? RESTEasyTracing.DEFAULT_LEVEL : RESTEasyTracingLevel.valueOf((String)((String)thresholdText));
    }

    static {
        SUMMARY_HEADERS.add("Accept".toLowerCase());
        SUMMARY_HEADERS.add("Accept-Encoding".toLowerCase());
        SUMMARY_HEADERS.add("Accept-Charset".toLowerCase());
        SUMMARY_HEADERS.add("Accept-Language".toLowerCase());
        SUMMARY_HEADERS.add("Content-Type".toLowerCase());
        SUMMARY_HEADERS.add("Content-Length".toLowerCase());
    }
}

