/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import org.jboss.remoting3.Attachments;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.MessageCancelledException;
import org.jboss.remoting3.MessageInputStream;
import org.jboss.remoting3.MessageOutputStream;
import org.jboss.remoting3.NotOpenException;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.xnio.IoUtils;
import org.xnio.streams.Pipe;

final class LocalChannel
extends AbstractHandleableCloseable<Channel>
implements Channel {
    private final Attachments attachments = new Attachments();
    private final LocalChannel otherSide;
    private final ConnectionHandlerContext connectionHandlerContext;
    private final Queue<In> messageQueue;
    private final Object lock = new Object();
    private final int queueLength;
    private final int bufferSize;
    private Channel.Receiver messageHandler;
    private boolean closed;

    LocalChannel(Executor executor, LocalChannel otherSide, ConnectionHandlerContext connectionHandlerContext) {
        super(executor);
        this.otherSide = otherSide;
        this.connectionHandlerContext = connectionHandlerContext;
        this.queueLength = 8;
        this.messageQueue = new ArrayDeque<In>(this.queueLength);
        this.bufferSize = 8192;
    }

    LocalChannel(Executor executor, ConnectionHandlerContext connectionHandlerContext) {
        super(executor);
        this.connectionHandlerContext = connectionHandlerContext;
        this.otherSide = new LocalChannel(executor, this, connectionHandlerContext);
        this.queueLength = 8;
        this.messageQueue = new ArrayDeque<In>(this.queueLength);
        this.bufferSize = 8192;
    }

    @Override
    public MessageOutputStream writeMessage() throws IOException {
        LocalChannel otherSide = this.otherSide;
        Queue<In> otherSideQueue = otherSide.messageQueue;
        Object object = otherSide.lock;
        synchronized (object) {
            Channel.Receiver handler;
            int size;
            while (true) {
                if (otherSide.closed) {
                    throw new NotOpenException("Writes have been shut down");
                }
                size = otherSideQueue.size();
                if (size != this.queueLength) break;
                try {
                    otherSide.lock.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            Pipe pipe = new Pipe(this.bufferSize);
            In in = new In(pipe.getIn());
            if (size == 0 && (handler = otherSide.messageHandler) != null) {
                otherSide.messageHandler = null;
                otherSide.lock.notify();
                this.executeMessageTask(handler, in);
                return new Out(pipe.getOut(), in);
            }
            otherSideQueue.add(in);
            otherSide.lock.notify();
            return new Out(pipe.getOut(), in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeShutdown() throws IOException {
        LocalChannel otherSide = this.otherSide;
        Object object = otherSide.lock;
        synchronized (object) {
            if (!otherSide.closed) {
                otherSide.closed = true;
                Channel.Receiver messageHandler = otherSide.messageHandler;
                if (messageHandler != null && otherSide.messageQueue.isEmpty()) {
                    this.executeEndTask(messageHandler);
                } else {
                    otherSide.lock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessage(Channel.Receiver handler) {
        Object lock;
        Object object = lock = this.lock;
        synchronized (object) {
            if (this.messageHandler != null) {
                throw new IllegalStateException("Message handler already waiting");
            }
            if (this.closed) {
                this.executeEndTask(handler);
            } else {
                In in = this.messageQueue.poll();
                if (in != null) {
                    this.executeMessageTask(handler, in);
                } else {
                    this.messageHandler = handler;
                    lock.notify();
                }
            }
        }
    }

    private void executeEndTask(final Channel.Receiver handler) {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                handler.handleEnd(LocalChannel.this);
            }
        });
    }

    private void executeMessageTask(final Channel.Receiver handler, final In in) {
        this.getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                handler.handleMessage(LocalChannel.this, in);
            }
        });
    }

    @Override
    public Attachments getAttachments() {
        return this.attachments;
    }

    @Override
    public Connection getConnection() {
        return this.connectionHandlerContext.getConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
            this.lock.notifyAll();
        }
        this.otherSide.connectionHandlerContext.remoteClosed();
        this.closeComplete();
    }

    LocalChannel getOtherSide() {
        return this.otherSide;
    }

    static final class In
    extends MessageInputStream {
        private final InputStream inputStream;
        private volatile boolean cancelled;

        In(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }

        synchronized void doCancel() {
            this.cancelled = true;
        }

        public synchronized boolean wasCancelled() {
            return this.cancelled;
        }

        @Override
        public int read() throws IOException {
            this.checkCancel();
            return this.inputStream.read();
        }

        private synchronized void checkCancel() throws MessageCancelledException {
            if (this.cancelled) {
                throw new MessageCancelledException();
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.checkCancel();
            return this.inputStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.checkCancel();
            return this.inputStream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            this.checkCancel();
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            this.checkCancel();
            return this.inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.checkCancel();
            this.inputStream.close();
        }

        @Override
        public void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.checkCancel();
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }
    }

    static final class Out
    extends MessageOutputStream {
        private final OutputStream outputStream;
        private final In in;

        Out(OutputStream outputStream, In in) {
            this.outputStream = outputStream;
            this.in = in;
        }

        @Override
        public void flush() throws IOException {
            this.outputStream.flush();
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }

        @Override
        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
        }

        @Override
        public Out cancel() {
            this.in.doCancel();
            IoUtils.safeClose((Closeable)this.outputStream);
            return this;
        }
    }
}

