/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.detection.jndi;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.detection.AbstractDetector;
import org.jboss.remoting.detection.Detection;
import org.jboss.remoting.detection.jndi.JNDIDetectorMBean;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.util.SecurityUtility;
import org.jnp.interfaces.NamingContextFactory;
import org.jnp.server.Main;

public class JNDIDetector
extends AbstractDetector
implements JNDIDetectorMBean {
    private int port;
    private String host;
    private String contextFactory = NamingContextFactory.class.getName();
    private String urlPackage = "org.jboss.naming:org.jnp.interfaces";
    private Identity id;
    private Context context;
    public static final String DETECTION_SUBCONTEXT_NAME = "detection";
    private String subContextName = "detection";
    private int detectionNumber;
    private int cleanDetectionCount = this.detectionNumber = 5;
    protected final Logger log = Logger.getLogger(this.getClass());
    static /* synthetic */ Class class$org$jboss$remoting$detection$jndi$JNDIDetector;

    public JNDIDetector() {
    }

    public JNDIDetector(Map config) {
        super(config);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getContextFactory() {
        return this.contextFactory;
    }

    public void setSubContextName(String subContextName) {
        this.subContextName = subContextName;
    }

    public String getSubContextName() {
        return this.subContextName;
    }

    public void setContextFactory(String contextFactory) {
        this.contextFactory = contextFactory;
    }

    public String getURLPackage() {
        return this.urlPackage;
    }

    public void setURLPackage(String urlPackage) {
        this.urlPackage = urlPackage;
    }

    public void start() throws Exception {
        this.createContext();
        this.id = Identity.get(this.mbeanserver);
        super.start();
    }

    protected void heartbeat() {
        try {
            if (this.context == null) {
                this.createContext();
            }
            this.checkRemoteDetectionMsg();
        }
        catch (NamingException nex) {
            this.log.error((Object)"Can not connect to JNDI server to register local connectors.", (Throwable)nex);
        }
    }

    protected void forceHeartbeat() {
        this.heartbeat();
    }

    public int getCleanDetectionNumber() {
        return this.detectionNumber;
    }

    public void setCleanDetectionNumber(int cleanDetectionNumber) {
        this.cleanDetectionCount = this.detectionNumber = cleanDetectionNumber;
    }

    private void checkRemoteDetectionMsg() {
        try {
            boolean localFound = false;
            ++this.cleanDetectionCount;
            boolean cleanDetect = this.cleanDetectionCount > this.detectionNumber;
            String bindName = "";
            NamingEnumeration enumeration = JNDIDetector.listBindings(this.context, bindName);
            while (enumeration.hasMore()) {
                Binding binding = (Binding)enumeration.next();
                Detection regMsg = (Detection)binding.getObject();
                if (this.isRemoteDetection(regMsg)) {
                    this.log.debug((Object)("Detected id: " + regMsg.getIdentity().getInstanceId() + ", message: " + regMsg));
                    if (cleanDetect) {
                        ClassLoader cl;
                        if (this.log.isTraceEnabled()) {
                            this.log.trace((Object)"Doing clean detection.");
                        }
                        if (!this.checkInvokerServer(regMsg, cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return (class$org$jboss$remoting$detection$jndi$JNDIDetector == null ? (class$org$jboss$remoting$detection$jndi$JNDIDetector = JNDIDetector.class$("org.jboss.remoting.detection.jndi.JNDIDetector")) : class$org$jboss$remoting$detection$jndi$JNDIDetector).getClassLoader();
                            }
                        }))) {
                            this.unregisterDetection(regMsg.getIdentity().getInstanceId());
                            continue;
                        }
                        this.detect(regMsg);
                        continue;
                    }
                    this.detect(regMsg);
                    continue;
                }
                if (!this.verifyLocalDetectionMsg(regMsg)) {
                    this.addLocalDetectionMsg();
                }
                localFound = true;
            }
            if (cleanDetect) {
                this.cleanDetectionCount = 0;
            }
            if (!localFound) {
                this.addLocalDetectionMsg();
            }
        }
        catch (NamingException e) {
            this.log.error((Object)"Exception getting detection messages from JNDI server.", (Throwable)e);
        }
    }

    private boolean verifyLocalDetectionMsg(Detection regMsg) throws NamingException {
        boolean verified = false;
        InvokerLocator[] locators = InvokerRegistry.getRegisteredServerLocators();
        Detection msg = this.createDetection();
        String sId = this.id.getInstanceId();
        InvokerLocator[] invokers = regMsg.getLocators();
        if (sId.equals(regMsg.getIdentity().getInstanceId())) {
            boolean changed = false;
            if (locators.length != invokers.length) {
                changed = true;
            } else {
                boolean found = false;
                for (int i = 0; i < locators.length; ++i) {
                    found = false;
                    for (int x = 0; x < invokers.length; ++x) {
                        if (!locators[i].equals(invokers[x])) continue;
                        found = true;
                        break;
                    }
                    if (!found) break;
                }
                if (!found) {
                    changed = true;
                }
            }
            if (changed) {
                this.registerDetectionMsg(sId, msg);
            }
            verified = true;
        }
        return verified;
    }

    private void addLocalDetectionMsg() throws NamingException {
        Detection msg = this.createDetection();
        String sId = this.id.getInstanceId();
        this.registerDetectionMsg(sId, msg);
    }

    private void registerDetectionMsg(String sId, Detection msg) throws NamingException {
        block3: {
            if (sId != null && msg != null) {
                try {
                    JNDIDetector.rebind(this.context, sId, msg);
                    this.log.info((Object)("Added " + sId + " to registry."));
                }
                catch (NameAlreadyBoundException nabex) {
                    if (!this.log.isTraceEnabled()) break block3;
                    this.log.trace((Object)(sId + " already bound to server."));
                }
            }
        }
    }

    private void verifyJNDIServer() {
        if (this.host == null || this.host.length() == 0) {
            try {
                this.log.info((Object)"JNDI Server configuration information not present so will create a local server.");
                Object namingBean = null;
                Class<?> namingBeanImplClass = null;
                try {
                    namingBeanImplClass = Class.forName("org.jnp.server.NamingBeanImpl");
                    namingBean = namingBeanImplClass.newInstance();
                    Method startMethod = namingBeanImplClass.getMethod("start", new Class[0]);
                    JNDIDetector.setSystemProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
                    startMethod.invoke(namingBean, new Object[0]);
                }
                catch (Exception e) {
                    this.log.debug((Object)"Cannot find NamingBeanImpl: must be running jdk 1.4");
                }
                this.host = JNDIDetector.getLocalHostName();
                this.port = PortUtil.findFreePort(this.host);
                this.log.info((Object)"Remoting JNDI detector starting JNDI server instance since none where specified via configuration.");
                this.log.info((Object)("Remoting JNDI server started on host + " + this.host + " and port " + this.port));
                Main server = new Main();
                if (namingBean != null) {
                    Class<?> namingBeanClass = Class.forName("org.jnp.server.NamingBean");
                    Method setNamingInfoMethod = server.getClass().getMethod("setNamingInfo", namingBeanClass);
                    setNamingInfoMethod.invoke((Object)server, namingBean);
                }
                server.setPort(this.port);
                server.setBindAddress(this.host);
                server.start();
                this.contextFactory = NamingContextFactory.class.getName();
                this.urlPackage = "org.jboss.naming:org.jnp.interfaces";
            }
            catch (Exception e) {
                this.log.error((Object)"Error starting up JNDI server since none was specified via configuration.", (Throwable)e);
            }
        }
    }

    private void createContext() throws NamingException {
        this.verifyJNDIServer();
        Properties env = new Properties();
        env.put("java.naming.factory.initial", this.contextFactory);
        env.put("java.naming.provider.url", this.host + ":" + this.port);
        env.put("java.naming.factory.url.pkgs", this.urlPackage);
        InitialContext initialContext = JNDIDetector.createContext(env);
        try {
            this.context = JNDIDetector.initialContextLookup(initialContext, this.subContextName);
        }
        catch (NamingException e) {
            try {
                this.context = JNDIDetector.createSubcontext(initialContext, this.subContextName);
            }
            catch (NameAlreadyBoundException e1) {
                this.log.debug((Object)("The sub context " + this.subContextName + " was created before we could."));
                this.context = JNDIDetector.initialContextLookup(initialContext, this.subContextName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        String sId2;
        try {
            super.stop();
            Object var2_1 = null;
            sId2 = this.id.getInstanceId();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            String sId2 = this.id.getInstanceId();
            try {
                this.unregisterDetection(sId2);
            }
            catch (NamingException e) {
                this.log.warn((Object)("Could not unregister " + sId2 + " before shutdown.  " + "Root cause is " + e.getMessage()));
            }
            throw throwable;
        }
        try {
            this.unregisterDetection(sId2);
        }
        catch (NamingException e) {
            this.log.warn((Object)("Could not unregister " + sId2 + " before shutdown.  " + "Root cause is " + e.getMessage()));
        }
    }

    private void unregisterDetection(String sId) throws NamingException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("unregistering detector " + sId));
        }
        JNDIDetector.unbind(this.context, sId);
    }

    private static void setSystemProperty(final String name, final String value) {
        if (SecurityUtility.skipAccessControl()) {
            System.setProperty(name, value);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return System.setProperty(name, value);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    private static InetAddress getLocalHost() throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (IOException e) {
                return InetAddress.getByName("127.0.0.1");
            }
        }
        try {
            return (InetAddress)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    try {
                        return InetAddress.getLocalHost();
                    }
                    catch (IOException e) {
                        return InetAddress.getByName("127.0.0.1");
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    private static String getLocalHostName() throws UnknownHostException {
        if (SecurityUtility.skipAccessControl()) {
            return JNDIDetector.getLocalHost().getHostName();
        }
        try {
            return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    InetAddress address = null;
                    try {
                        address = InetAddress.getLocalHost();
                    }
                    catch (IOException e) {
                        address = InetAddress.getByName("127.0.0.1");
                    }
                    return address.getHostName();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (UnknownHostException)e.getCause();
        }
    }

    private static Context createSubcontext(final InitialContext initialContext, final String subContextName) throws NamingException {
        if (SecurityUtility.skipAccessControl()) {
            return initialContext.createSubcontext(subContextName);
        }
        try {
            return (Context)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return initialContext.createSubcontext(subContextName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
    }

    private static Context initialContextLookup(final InitialContext initialContext, final String subContextName) throws NamingException {
        if (SecurityUtility.skipAccessControl()) {
            return (Context)initialContext.lookup(subContextName);
        }
        try {
            return (Context)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return initialContext.lookup(subContextName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
    }

    private static NamingEnumeration listBindings(final Context context, final String bindName) throws NamingException {
        if (SecurityUtility.skipAccessControl()) {
            return context.listBindings(bindName);
        }
        try {
            return (NamingEnumeration)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return context.listBindings(bindName);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
    }

    private static void rebind(final Context context, final String name, final Object object) throws NamingException {
        if (SecurityUtility.skipAccessControl()) {
            context.rebind(name, object);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    context.rebind(name, object);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
    }

    private static void unbind(final Context context, final String name) throws NamingException {
        if (SecurityUtility.skipAccessControl()) {
            context.unbind(name);
            return;
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    context.unbind(name);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
    }

    private static InitialContext createContext(final Properties env) throws NamingException {
        if (SecurityUtility.skipAccessControl()) {
            return new InitialContext(env);
        }
        try {
            return (InitialContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return new InitialContext(env);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (RuntimeException)e.getCause();
        }
    }
}

