/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context.exception;

import javax.faces.FacesException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import org.jboss.portletbridge.bridge.factory.BridgeLoggerFactoryImpl;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;

public class AjaxPortletExceptionHandler
extends ExceptionHandlerWrapper {
    private static final BridgeLogger logger = BridgeLoggerFactoryImpl.getLogger(AjaxPortletExceptionHandler.class.getName());
    private ExceptionHandler wrapped;

    public AjaxPortletExceptionHandler(ExceptionHandler exceptionHandler) {
        this.wrapped = exceptionHandler;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public void handle() throws FacesException {
        for (ExceptionQueuedEvent event : this.getUnhandledExceptionQueuedEvents()) {
            ExceptionQueuedEventContext context = event.getContext();
            if (null != context) {
                Throwable throwable = context.getException();
                if (null != throwable) {
                    logger.log(BridgeLogger.Level.ERROR, "Exception while processing Ajax Request in Portlet Bridge", throwable);
                    continue;
                }
                logger.log(BridgeLogger.Level.ERROR, "Null exception found on ExceptionQueuedEventContext in Phase: " + context.getPhaseId() + " and Component:" + context.getComponent());
                continue;
            }
            logger.log(BridgeLogger.Level.ERROR, "ExceptionQueuedEventContext null for ExceptionQueuedEvent: " + event.toString());
        }
        super.handle();
    }
}

