/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.retro;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeployer;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.installer.ArtifactInstallationException;
import org.apache.maven.artifact.installer.ArtifactInstaller;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.metadata.ResolutionGroup;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.jboss.maven.plugins.retro.AbstractWeaveMojo;

public class WeaveDependenciesMojo
extends AbstractWeaveMojo {
    protected ArtifactResolver artifactResolver;
    protected ArtifactMetadataSource artifactMetadataSource;
    protected ArtifactRepository localRepository;
    private File localRepositoryPath;
    private String localRepositoryId;
    private Map repositoryLayouts;
    protected ArtifactInstaller installer;
    private ArtifactDeployer deployer;
    protected List pluginArtifacts;
    private String deployUrl;
    private String repositoryLayout;
    protected String outputDirectory;
    private ArtifactRepositoryFactory repositoryFactory;
    private String repositoryId;
    private boolean uniqueVersion;
    private boolean deployDependencies;
    private boolean installDependencies;

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (StringUtils.isNotEmpty((String)this.localRepositoryId) && this.localRepositoryPath != null) {
            try {
                ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)this.repositoryLayouts.get(this.repositoryLayout);
                this.getLog().info((CharSequence)("Layout: " + layout.getClass()));
                this.localRepository = new DefaultArtifactRepository(this.localRepositoryId, this.localRepositoryPath.toURL().toString(), layout);
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("MalformedURLException: " + e.getMessage(), (Exception)e);
            }
        }
        this.getLog().info((CharSequence)"Weaving dependencies");
        this.weaveDependencies();
        this.getLog().info((CharSequence)"Weaving complete.");
    }

    protected void weaveDependencies() throws MojoFailureException, MojoExecutionException {
        Set dependencyArtifacts = this.project.getDependencyArtifacts();
        HashMap<Artifact, File> weavedDependencies = new HashMap<Artifact, File>();
        try {
            ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(dependencyArtifacts, this.project.getArtifact(), this.project.getRemoteArtifactRepositories(), this.localRepository, this.artifactMetadataSource);
            Set artifacts = result.getArtifacts();
            File parentDir = new File(this.getOutputPath());
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            for (Object artifactObj : artifacts) {
                Artifact artifact = (Artifact)artifactObj;
                this.getLog().info((CharSequence)("Weaving " + artifact));
                String srcJar = artifact.getFile().getAbsolutePath();
                File outputJarFile = new File(this.getOutputPath() + File.separator + artifact.getFile().getName());
                String destJar = outputJarFile.getAbsolutePath();
                String classpath = this.buildClasspath(artifacts);
                String[] args = this.generateWeaverArgs(classpath, srcJar, destJar);
                try {
                    this.doWeave(classpath, args);
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Exception while weaving " + artifact.getArtifactId() + "\n" + e.getMessage()));
                }
                weavedDependencies.put(artifact, outputJarFile);
            }
            if (this.installDependencies) {
                this.installDependencies(weavedDependencies);
            }
            if (this.deployDependencies) {
                this.deployDependencies(weavedDependencies);
            }
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactInstallationException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    protected String[] generateWeaverArgs(String classpath, String srcJar, String destJar) {
        ArrayList<String> argsList = new ArrayList<String>();
        if (this.verbose) {
            argsList.add("-verbose");
        }
        if (this.suppress) {
            argsList.add("-suppress");
        }
        argsList.add("-cp");
        argsList.add(classpath);
        argsList.add("-useSystemClasspath");
        argsList.add("false");
        if (this.weaverClass != null) {
            argsList.add("-weaverClass");
            argsList.add(this.weaverClass);
        }
        argsList.add("-outputJar");
        argsList.add(destJar);
        argsList.add(srcJar);
        String[] args = new String[argsList.size()];
        return argsList.toArray(args);
    }

    protected String buildClasspath(Set artifacts) {
        Artifact artifact;
        StringBuilder classpath = new StringBuilder();
        for (Object artifactObj : artifacts) {
            artifact = (Artifact)artifactObj;
            classpath.append(artifact.getFile().getAbsolutePath());
            classpath.append(this.pathSep);
        }
        for (Object artifactObj : this.pluginArtifacts) {
            try {
                artifact = (Artifact)artifactObj;
                if (artifact.getFile() == null) continue;
                classpath.append(artifact.getFile().getCanonicalPath());
                classpath.append(this.pathSep);
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)"Could not get filename");
            }
        }
        return classpath.toString();
    }

    protected File getPomFile(Artifact artifact) throws MojoExecutionException {
        Artifact pomArtifact = null;
        try {
            ResolutionGroup resGroup = this.artifactMetadataSource.retrieve(artifact, this.localRepository, this.project.getRemoteArtifactRepositories());
            pomArtifact = resGroup.getPomArtifact();
            this.artifactResolver.resolve(pomArtifact, this.project.getRemoteArtifactRepositories(), this.localRepository);
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        if (pomArtifact == null) {
            return null;
        }
        return pomArtifact.getFile();
    }

    private void installDependencies(Map artifacts) throws MojoExecutionException, ArtifactInstallationException {
        for (Object artifactObj : artifacts.keySet()) {
            Artifact artifact = (Artifact)artifactObj;
            File weavedArtifactFile = (File)artifacts.get(artifact);
            this.attachPomMetadata(artifact);
            this.installer.install(weavedArtifactFile, artifact, this.localRepository);
        }
    }

    private void deployDependencies(Map artifacts) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Deploying dependencies");
        ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)this.repositoryLayouts.get(this.repositoryLayout);
        if (this.deployUrl == null) {
            throw new MojoExecutionException("Parameter deployUrl must be set to a valid URL when deploying artifacts");
        }
        ArtifactRepository deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository(this.repositoryId, this.deployUrl, layout, this.uniqueVersion);
        String protocol = deploymentRepository.getProtocol();
        if (protocol.equals("") || protocol == null) {
            throw new MojoExecutionException("No transfer protocol found.");
        }
        for (Object artifactObj : artifacts.keySet()) {
            Artifact artifact = (Artifact)artifactObj;
            File weavedArtifactFile = (File)artifacts.get(artifact);
            this.attachPomMetadata(artifact);
            try {
                this.getDeployer().deploy(weavedArtifactFile, artifact, deploymentRepository, this.getLocalRepository());
            }
            catch (ArtifactDeploymentException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private void attachPomMetadata(Artifact artifact) throws MojoExecutionException {
        File pomFile = this.getPomFile(artifact);
        File retroPomFile = new File(this.getOutputPath() + File.separator + artifact.getArtifactId() + "-" + artifact.getVersion() + ".pom");
        try {
            FileUtils.copyFile((File)pomFile, (File)retroPomFile);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException(ioe.getMessage(), (Exception)ioe);
        }
        ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, retroPomFile);
        artifact.addMetadata((ArtifactMetadata)metadata);
    }

    public ArtifactDeployer getDeployer() {
        return this.deployer;
    }

    public void setDeployer(ArtifactDeployer deployer) {
        this.deployer = deployer;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public String getOutputPath() {
        return this.outputDirectory;
    }
}

