/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.jboss.logmanager.AtomicArray;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogManager;
import org.jboss.logmanager.LoggerNode;
import org.jboss.logmanager.SerializedLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Logger
extends java.util.logging.Logger
implements Serializable {
    private static final long serialVersionUID = 5093333069125075416L;
    private final LoggerNode loggerNode;
    private volatile Handler[] handlers;
    private volatile boolean useParentHandlers = true;
    private volatile Filter filter;
    private volatile Map<AttachmentKey, Object> attachments = Collections.emptyMap();
    private static final AtomicArray<Logger, Handler> handlersUpdater = AtomicArray.create(AtomicReferenceFieldUpdater.newUpdater(Logger.class, Handler[].class, "handlers"), Handler.class);
    private static final AtomicReferenceFieldUpdater<Logger, Map> attachmentsUpdater = AtomicReferenceFieldUpdater.newUpdater(Logger.class, Map.class, "attachments");
    private static final String LOGGER_CLASS_NAME = Logger.class.getName();
    private volatile Level level;
    private volatile int effectiveLevel = INFO_INT;
    private static final int OFF_INT = Level.OFF.intValue();
    private static final int SEVERE_INT = Level.SEVERE.intValue();
    private static final int WARNING_INT = Level.WARNING.intValue();
    private static final int INFO_INT = Level.INFO.intValue();
    private static final int CONFIG_INT = Level.CONFIG.intValue();
    private static final int FINE_INT = Level.FINE.intValue();
    private static final int FINER_INT = Level.FINER.intValue();
    private static final int FINEST_INT = Level.FINEST.intValue();

    public static Logger getLogger(String name) {
        try {
            return (Logger)java.util.logging.Logger.getLogger(name);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("The LogManager was not properly installed (you must set the \"java.util.logging.manager\" system property to \"" + LogManager.class.getName() + "\")");
        }
    }

    public static Logger getLogger(String name, String bundleName) {
        try {
            return (Logger)java.util.logging.Logger.getLogger(name, bundleName);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("The LogManager was not properly installed (you must set the \"java.util.logging.manager\" system property to \"" + LogManager.class.getName() + "\")");
        }
    }

    Logger(LoggerNode loggerNode, String name) {
        super(name, null);
        super.setLevel(Level.ALL);
        this.loggerNode = loggerNode;
        handlersUpdater.clear(this);
    }

    protected final Object writeReplace() throws ObjectStreamException {
        return new SerializedLogger(this.getName());
    }

    @Override
    public void setFilter(Filter filter) throws SecurityException {
        LogContext.checkAccess();
        this.filter = filter;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        LogContext.checkAccess();
        LogContext context = this.loggerNode.getContext();
        Lock lock = context.treeLock;
        lock.lock();
        try {
            int newEffectiveLevel;
            int oldEffectiveLevel = this.effectiveLevel;
            if (newLevel != null) {
                this.level = newLevel;
                newEffectiveLevel = newLevel.intValue();
            } else {
                Logger parent = this.getParent();
                if (parent == null) {
                    this.level = Level.INFO;
                    newEffectiveLevel = INFO_INT;
                } else {
                    this.level = null;
                    newEffectiveLevel = parent.effectiveLevel;
                }
            }
            this.effectiveLevel = newEffectiveLevel;
            if (oldEffectiveLevel != newEffectiveLevel) {
                this.loggerNode.updateChildEffectiveLevel(newEffectiveLevel);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void setLevelName(String newLevelName) throws SecurityException {
        this.setLevel(this.loggerNode.getContext().getLevelForName(newLevelName));
    }

    void setEffectiveLevel(int newLevel) {
        if (this.level == null) {
            this.effectiveLevel = newLevel;
            this.loggerNode.updateChildEffectiveLevel(newLevel);
        }
    }

    public int getEffectiveLevel() {
        return this.effectiveLevel;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public boolean isLoggable(Level level) {
        int effectiveLevel = this.effectiveLevel;
        return level.intValue() >= effectiveLevel && effectiveLevel != OFF_INT;
    }

    public <V> V getAttachment(AttachmentKey<V> key) {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        Map<AttachmentKey, Object> attachments = this.attachments;
        return (V)attachments.get(key);
    }

    public <V> V attach(AttachmentKey<V> key, V value) throws SecurityException {
        Object old;
        Map<AttachmentKey<V>, V> newAttachments;
        Map<AttachmentKey, Object> oldAttachments;
        LogContext.checkAccess();
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        do {
            if ((oldAttachments = this.attachments).isEmpty() || oldAttachments.size() == 1 && oldAttachments.containsKey(key)) {
                old = oldAttachments.get(key);
                newAttachments = Collections.singletonMap(key, value);
                continue;
            }
            newAttachments = new HashMap<AttachmentKey, Object>(oldAttachments);
            old = newAttachments.put(key, value);
        } while (!attachmentsUpdater.compareAndSet(this, oldAttachments, newAttachments));
        return (V)old;
    }

    public <V> V attachIfAbsent(AttachmentKey<V> key, V value) throws SecurityException {
        Map<AttachmentKey<V>, V> newAttachments;
        Map<AttachmentKey, Object> oldAttachments;
        LogContext.checkAccess();
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        do {
            if ((oldAttachments = this.attachments).isEmpty()) {
                newAttachments = Collections.singletonMap(key, value);
                continue;
            }
            if (oldAttachments.containsKey(key)) {
                return (V)oldAttachments.get(key);
            }
            newAttachments = new HashMap<AttachmentKey, Object>(oldAttachments);
            newAttachments.put(key, value);
        } while (!attachmentsUpdater.compareAndSet(this, oldAttachments, newAttachments));
        return null;
    }

    public <V> V detach(AttachmentKey<V> key) throws SecurityException {
        Object result;
        Map<Object, Object> newAttachments;
        Map<AttachmentKey, Object> oldAttachments;
        LogContext.checkAccess();
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        do {
            if ((result = (oldAttachments = this.attachments).get(key)) == null) {
                return null;
            }
            int size = oldAttachments.size();
            if (size == 1) {
                newAttachments = Collections.emptyMap();
                continue;
            }
            if (size == 2) {
                Iterator<Map.Entry<AttachmentKey, Object>> it = oldAttachments.entrySet().iterator();
                Map.Entry<AttachmentKey, Object> entry = it.next();
                if (entry.getKey() == key) {
                    entry = it.next();
                }
                newAttachments = Collections.singletonMap(entry.getKey(), entry.getValue());
                continue;
            }
            newAttachments = new HashMap<AttachmentKey, Object>(oldAttachments);
        } while (!attachmentsUpdater.compareAndSet(this, oldAttachments, newAttachments));
        return (V)result;
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        LogContext.checkAccess();
        if (handler == null) {
            throw new NullPointerException("handler is null");
        }
        handlersUpdater.add(this, handler);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        LogContext.checkAccess();
        if (handler == null) {
            return;
        }
        handlersUpdater.remove(this, handler, true);
    }

    @Override
    public Handler[] getHandlers() {
        Handler[] handlers = this.handlers;
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    public Handler[] clearHandlers() throws SecurityException {
        LogContext.checkAccess();
        Handler[] handlers = this.handlers;
        handlersUpdater.clear(this);
        return handlers.length > 0 ? (Handler[])handlers.clone() : handlers;
    }

    @Override
    public void setUseParentHandlers(boolean useParentHandlers) {
        this.useParentHandlers = useParentHandlers;
    }

    @Override
    public boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    @Override
    public Logger getParent() {
        return this.loggerNode.getParentLogger();
    }

    @Override
    public void setParent(java.util.logging.Logger parent) {
        throw new SecurityException("setParent() disallowed");
    }

    @Override
    public void log(LogRecord record) {
        int effectiveLevel = this.effectiveLevel;
        if (record.getLevel().intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        this.logRaw(record);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        if (FINER_INT < this.effectiveLevel) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "ENTRY", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        this.logRaw(rec);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (FINER_INT < this.effectiveLevel) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "ENTRY {0}", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(new Object[]{param1});
        this.logRaw(rec);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (FINER_INT < this.effectiveLevel) {
            return;
        }
        StringBuilder builder = new StringBuilder("ENTRY");
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                builder.append(" {").append(i).append('}');
            }
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, builder.toString(), LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        if (params != null) {
            rec.setParameters(params);
        }
        this.logRaw(rec);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        if (FINER_INT < this.effectiveLevel) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "RETURN", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        this.logRaw(rec);
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (FINER_INT < this.effectiveLevel) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "RETURN {0}", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(new Object[]{result});
        this.logRaw(rec);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (FINER_INT < this.effectiveLevel) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(Level.FINER, "THROW", LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        this.logRaw(rec);
    }

    @Override
    public void severe(String msg) {
        if (SEVERE_INT < this.effectiveLevel) {
            return;
        }
        this.logRaw(new ExtLogRecord(Level.SEVERE, msg, LOGGER_CLASS_NAME));
    }

    @Override
    public void warning(String msg) {
        if (WARNING_INT < this.effectiveLevel) {
            return;
        }
        this.logRaw(new ExtLogRecord(Level.WARNING, msg, LOGGER_CLASS_NAME));
    }

    @Override
    public void info(String msg) {
        if (INFO_INT < this.effectiveLevel) {
            return;
        }
        this.logRaw(new ExtLogRecord(Level.INFO, msg, LOGGER_CLASS_NAME));
    }

    @Override
    public void config(String msg) {
        if (CONFIG_INT < this.effectiveLevel) {
            return;
        }
        this.logRaw(new ExtLogRecord(Level.CONFIG, msg, LOGGER_CLASS_NAME));
    }

    @Override
    public void fine(String msg) {
        if (FINE_INT < this.effectiveLevel) {
            return;
        }
        this.logRaw(new ExtLogRecord(Level.FINE, msg, LOGGER_CLASS_NAME));
    }

    @Override
    public void finer(String msg) {
        if (FINER_INT < this.effectiveLevel) {
            return;
        }
        this.logRaw(new ExtLogRecord(Level.FINER, msg, LOGGER_CLASS_NAME));
    }

    @Override
    public void finest(String msg) {
        if (FINEST_INT < this.effectiveLevel) {
            return;
        }
        this.logRaw(new ExtLogRecord(Level.FINEST, msg, LOGGER_CLASS_NAME));
    }

    @Override
    public void log(Level level, String msg) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        this.logRaw(new ExtLogRecord(level, msg, LOGGER_CLASS_NAME));
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setParameters(new Object[]{param1});
        this.logRaw(rec);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        if (params != null) {
            rec.setParameters(params);
        }
        this.logRaw(rec);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setThrown(thrown);
        this.logRaw(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        this.logRaw(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setParameters(new Object[]{param1});
        this.logRaw(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        if (params != null) {
            rec.setParameters(params);
        }
        this.logRaw(rec);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setThrown(thrown);
        this.logRaw(rec);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setResourceBundleName(bundleName);
        this.logRaw(rec);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setResourceBundleName(bundleName);
        rec.setParameters(new Object[]{param1});
        this.logRaw(rec);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setResourceBundleName(bundleName);
        if (params != null) {
            rec.setParameters(params);
        }
        this.logRaw(rec);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        int effectiveLevel = this.effectiveLevel;
        if (level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, msg, LOGGER_CLASS_NAME);
        rec.setSourceClassName(sourceClass);
        rec.setSourceMethodName(sourceMethod);
        rec.setResourceBundleName(bundleName);
        rec.setThrown(thrown);
        this.logRaw(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.setLevel(null);
        }
        finally {
            super.finalize();
        }
    }

    public void log(String fqcn, Level level, String message, String bundleName, ExtLogRecord.FormatStyle style, Object[] params, Throwable t) {
        int effectiveLevel = this.effectiveLevel;
        if (level == null || fqcn == null || message == null || level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, message, style, fqcn);
        rec.setResourceBundleName(bundleName);
        rec.setParameters(params);
        rec.setThrown(t);
        this.logRaw(rec);
    }

    public void log(String fqcn, Level level, String message, ExtLogRecord.FormatStyle style, Object[] params, Throwable t) {
        int effectiveLevel = this.effectiveLevel;
        if (level == null || fqcn == null || message == null || level.intValue() < effectiveLevel || effectiveLevel == OFF_INT) {
            return;
        }
        ExtLogRecord rec = new ExtLogRecord(level, message, style, fqcn);
        rec.setParameters(params);
        rec.setThrown(t);
        this.logRaw(rec);
    }

    public void log(String fqcn, Level level, String message, Throwable t) {
        this.log(fqcn, level, message, ExtLogRecord.FormatStyle.MESSAGE_FORMAT, null, t);
    }

    public void logRaw(ExtLogRecord record) {
        record.setLoggerName(this.getName());
        String bundleName = null;
        ResourceBundle bundle = null;
        for (Logger current = this; current != null; current = current.getParent()) {
            bundleName = current.getResourceBundleName();
            if (bundleName == null) continue;
            bundle = current.getResourceBundle();
            break;
        }
        if (bundleName != null && bundle != null) {
            record.setResourceBundleName(bundleName);
            record.setResourceBundle(bundle);
        }
        Filter filter = this.filter;
        try {
            if (filter != null && !filter.isLoggable(record)) {
                return;
            }
        }
        catch (VirtualMachineError e) {
            throw e;
        }
        catch (Throwable t) {
            // empty catch block
        }
        for (Logger current = this; current != null; current = current.getParent()) {
            Handler[] handlers = current.handlers;
            if (handlers != null) {
                for (Handler handler : handlers) {
                    try {
                        handler.publish(record);
                    }
                    catch (VirtualMachineError e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            if (!current.useParentHandlers) break;
        }
    }

    public void logRaw(LogRecord record) {
        this.logRaw(ExtLogRecord.wrap(record));
    }

    public String toString() {
        return "Logger '" + this.getName() + "' in context " + this.loggerNode.getContext();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AttachmentKey<V> {
    }
}

