/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service;

import java.net.URL;
import java.util.List;
import java.util.Set;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappLoader;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.service.TomcatInjectionContainer;
import org.jboss.web.tomcat.service.WebAppClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebAppLoader
extends WebappLoader {
    private static final Logger log = Logger.getLogger(WebAppLoader.class);
    private String[] filteredPackages = new String[]{"org.apache.commons.logging"};
    private List<URL> classpath;
    private TomcatInjectionContainer injectionContainer;

    public WebAppLoader() {
        this.setLoaderClass(WebAppClassLoader.class.getName());
    }

    public WebAppLoader(ClassLoader parent, Set<String> filteredPackages) {
        this(parent, filteredPackages, null);
    }

    public WebAppLoader(ClassLoader parent, Set<String> filteredPackages, TomcatInjectionContainer container) {
        super(parent);
        this.setLoaderClass(WebAppClassLoader.class.getName());
        if (filteredPackages != null) {
            this.filteredPackages = new String[filteredPackages.size()];
            filteredPackages.toArray(this.filteredPackages);
        }
        this.injectionContainer = container;
    }

    public WebAppLoader(ClassLoader parent, String[] filteredPackages, TomcatInjectionContainer container) {
        super(parent);
        this.setLoaderClass(WebAppClassLoader.class.getName());
        this.filteredPackages = filteredPackages;
        this.injectionContainer = container;
    }

    public void setClasspath(List<URL> classpath) {
        this.classpath = classpath;
    }

    public void start() throws LifecycleException {
        super.start();
        ClassLoader loader = this.getClassLoader();
        if (loader instanceof WebAppClassLoader) {
            WebAppClassLoader webLoader = (WebAppClassLoader)((Object)loader);
            webLoader.setFilteredPackages(this.filteredPackages);
            if (this.classpath != null) {
                for (URL url : this.classpath) {
                    webLoader.addURL(url);
                }
            }
        }
        if (this.injectionContainer != null) {
            log.debug((Object)"injectionContainer enabled and processing beginning with Tomcat WebAppLoader");
            this.injectionContainer.setClassLoader(this.getClassLoader());
            this.injectionContainer.processMetadata();
        }
    }
}

