/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.ssl;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.security.cert.Certificate;
import java.util.Hashtable;
import java.util.Properties;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;

public class RMISSLClientSocketFactory
implements HandshakeCompletedListener,
RMIClientSocketFactory,
Serializable {
    public static final String HANDSHAKE_COMPLETE_LISTENER = "org.jboss.security.ssl.HandshakeCompletedListener";
    private static Logger log = Logger.getLogger(RMISSLClientSocketFactory.class);
    private static final long serialVersionUID = -6412485012870705607L;
    private boolean wantsClientAuth = true;
    private boolean needsClientAuth = false;

    public boolean isWantsClientAuth() {
        return this.wantsClientAuth;
    }

    public void setWantsClientAuth(boolean wantsClientAuth) {
        this.wantsClientAuth = wantsClientAuth;
    }

    public boolean isNeedsClientAuth() {
        return this.needsClientAuth;
    }

    public void setNeedsClientAuth(boolean needsClientAuth) {
        this.needsClientAuth = needsClientAuth;
    }

    public Socket createSocket(String host, int port) throws IOException {
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
        socket.addHandshakeCompletedListener(this);
        socket.setWantClientAuth(this.wantsClientAuth);
        socket.setNeedClientAuth(this.needsClientAuth);
        log.debug((Object)("createSocket, host=" + host + ", port=" + port + ",needsClientAuth=" + this.needsClientAuth + ", wantsClientAuth=" + this.wantsClientAuth));
        return socket;
    }

    public boolean equals(Object obj) {
        return obj instanceof RMISSLClientSocketFactory;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        int n;
        String cipher = event.getCipherSuite();
        SSLSession session = event.getSession();
        String peerHost = session.getPeerHost();
        Certificate[] localCerts = event.getLocalCertificates();
        Certificate[] peerCerts = null;
        try {
            peerCerts = event.getPeerCertificates();
        }
        catch (Exception e) {
            log.debug((Object)"Failed to retrieve peer certs", (Throwable)e);
        }
        log.debug((Object)("SSL handshakeCompleted, cipher=" + cipher + ", peerHost=" + peerHost));
        int count = localCerts != null ? localCerts.length : 0;
        log.debug((Object)("ClientCertChain length: " + count));
        for (n = 0; n < count; ++n) {
            log.debug((Object)("Cert[" + n + "]=" + localCerts[n]));
        }
        count = peerCerts != null ? peerCerts.length : 0;
        log.debug((Object)("PeerCertChain length: " + count));
        for (n = 0; n < count; ++n) {
            log.debug((Object)("Cert[" + n + "]=" + peerCerts[n]));
        }
        try {
            Properties env = System.getProperties();
            HandshakeCompletedListener listener = (HandshakeCompletedListener)((Hashtable)env).get(HANDSHAKE_COMPLETE_LISTENER);
            if (listener != null) {
                listener.handshakeCompleted(event);
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Failed to foward handshakeCompleted", e);
        }
    }
}

