/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration.password;

import java.lang.reflect.Method;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.security.integration.password.Password;
import org.jboss.security.integration.password.PasswordMaskManagement;
import org.jboss.security.integration.password.SecurityActions;

public class PasswordLifecycleCallback {
    private static final Logger log = Logger.getLogger(PasswordLifecycleCallback.class);
    private PasswordMaskManagement passwordManagement = null;

    public void setPasswordManagement(PasswordMaskManagement passwordManagement) {
        this.passwordManagement = passwordManagement;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        MethodInvocation mi = (MethodInvocation)invocation;
        KernelControllerContext context = (KernelControllerContext)mi.getArguments()[0];
        boolean trace = log.isTraceEnabled();
        Password passwordAnnotation = (Password)invocation.resolveClassAnnotation(Password.class);
        if (trace) {
            log.trace((Object)("Checking method: " + mi.getMethod() + ", bindingInfo: " + passwordAnnotation));
        }
        if ("setKernelControllerContext".equals(mi.getMethod().getName()) && passwordAnnotation != null) {
            String securityDomain = passwordAnnotation.securityDomain();
            char[] passwd = this.passwordManagement.getPassword(securityDomain);
            Object target = context.getTarget();
            this.setPassword(target, passwordAnnotation, passwd);
        } else if (passwordAnnotation != null) {
            log.trace((Object)"Ignoring unsetKernelControllerContext callback");
        } else if (trace) {
            log.trace((Object)"Ignoring null password info");
        }
        return null;
    }

    public void install(ControllerContext context) throws Exception {
        String securityDomain;
        char[] passwd;
        Password passwordAnnotation = this.readPasswordAnnotation(context);
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Binding into JNDI: " + context.getName() + ", passwordInfo: " + passwordAnnotation));
        }
        if ((passwd = this.passwordManagement.getPassword(securityDomain = passwordAnnotation.securityDomain())) == null) {
            log.trace((Object)("Password does not exist for security domain=" + securityDomain));
        }
        String methodName = passwordAnnotation.methodName();
        Object target = context.getTarget();
        if (trace) {
            log.trace((Object)("Trying to set password on " + target + " with method :" + methodName));
        }
        this.setPassword(target, passwordAnnotation, passwd);
    }

    public void uninstall(ControllerContext context) throws Exception {
    }

    private Password readPasswordAnnotation(ControllerContext context) throws Exception {
        MetaData metaData = context.getScopeInfo().getMetaData();
        if (metaData != null) {
            return (Password)metaData.getAnnotation(Password.class);
        }
        return null;
    }

    private void setPassword(Object target, Password passwordAnnotation, char[] passwd) throws Exception {
        Class<?> clazz = target.getClass();
        String methodName = passwordAnnotation.methodName();
        if (methodName == null) {
            throw new IllegalStateException("methodName " + methodName + " not configured on " + "the Password annotation for target:" + clazz);
        }
        Method m = SecurityActions.getMethod(clazz, methodName);
        try {
            m.invoke(target, new Object[]{passwd});
        }
        catch (Exception e) {
            log.trace((Object)("Error setting password on " + clazz + ". Will try the string version."));
            m.invoke(target, new String(passwd));
        }
    }
}

