/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.integration;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.ObjectFactory;
import org.jboss.security.integration.JNDIBasedSecurityManagement;
import org.jboss.security.integration.SecurityActions;
import org.jboss.security.plugins.SecurityDomainContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityDomainObjectFactory
implements InvocationHandler,
ObjectFactory {
    private JNDIBasedSecurityManagement securityManagement = new JNDIBasedSecurityManagement();

    public void setSecurityManagement(JNDIBasedSecurityManagement sm) {
        this.securityManagement = sm;
    }

    @Override
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        ClassLoader loader = SecurityActions.getContextClassLoader();
        Class[] interfaces = new Class[]{Context.class};
        Context ctx = (Context)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)this);
        return ctx;
    }

    @Override
    public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        InitialContext ctx = new InitialContext();
        NameParser parser = ctx.getNameParser("");
        String securityDomain = null;
        Name name = null;
        String methodName = method.getName();
        if (methodName.equals("toString")) {
            return "java:/jaas Context proxy";
        }
        if (methodName.equals("list")) {
            return new DomainEnumeration(JNDIBasedSecurityManagement.securityMgrMap.keys(), JNDIBasedSecurityManagement.securityMgrMap);
        }
        if (methodName.equals("bind") || methodName.equals("rebind")) {
            name = args[0] instanceof String ? parser.parse((String)args[0]) : (Name)args[0];
            securityDomain = name.get(0);
            SecurityDomainContext val = (SecurityDomainContext)args[1];
            JNDIBasedSecurityManagement.securityMgrMap.put(securityDomain, val);
            return obj;
        }
        if (!methodName.equals("lookup")) {
            throw new OperationNotSupportedException("Only lookup is supported, op=" + method);
        }
        name = args[0] instanceof String ? parser.parse((String)args[0]) : (Name)args[0];
        securityDomain = name.get(0);
        SecurityDomainContext securityDomainCtx = this.lookupSecurityDomain(securityDomain);
        Object binding = securityDomainCtx.getSecurityManager();
        if (name.size() == 2) {
            String request = name.get(1);
            binding = securityDomainCtx.lookup(request);
        }
        return binding;
    }

    private SecurityDomainContext lookupSecurityDomain(String securityDomain) throws Exception {
        SecurityDomainContext sdc = JNDIBasedSecurityManagement.securityMgrMap.get(securityDomain);
        if (sdc == null) {
            sdc = this.securityManagement.createSecurityDomainContext(securityDomain);
            JNDIBasedSecurityManagement.securityMgrMap.put(securityDomain, sdc);
        }
        return sdc;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DomainEnumeration
    implements NamingEnumeration<NameClassPair> {
        Enumeration<String> domains;
        Map<String, SecurityDomainContext> ctxMap;

        DomainEnumeration(Enumeration<String> domains, Map<String, SecurityDomainContext> ctxMap) {
            this.domains = domains;
            this.ctxMap = ctxMap;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasMoreElements() {
            return this.domains.hasMoreElements();
        }

        @Override
        public boolean hasMore() {
            return this.domains.hasMoreElements();
        }

        @Override
        public NameClassPair next() {
            String name = this.domains.nextElement();
            SecurityDomainContext value = this.ctxMap.get(name);
            String className = value.getClass().getName();
            NameClassPair pair = new NameClassPair(name, className);
            return pair;
        }

        @Override
        public NameClassPair nextElement() {
            return this.next();
        }
    }
}

