/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class CustomObjectInputStreamWithClassloader
extends ObjectInputStream {
    ClassLoader cl;

    public CustomObjectInputStreamWithClassloader(InputStream in, ClassLoader cl) throws IOException {
        super(in);
        this.cl = cl;
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        return ObjectStreamClass.lookup(this.cl.loadClass(this.readUTF()));
    }

    protected Class resolveClass(ObjectStreamClass classdesc) throws IOException, ClassNotFoundException {
        return this.cl.loadClass(classdesc.getName());
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] interfacesClass = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfacesClass[i] = Class.forName(interfaces[i], false, this.cl);
        }
        return Proxy.getProxyClass(this.cl, interfacesClass);
    }
}

