/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aop.Advised;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.remoting.ClusterChooserInterceptor;
import org.jboss.aspects.remoting.ClusterConstants;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.aspects.remoting.ForwardingInterceptor;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.aspects.remoting.IsLocalInterceptor;
import org.jboss.aspects.remoting.MergeMetaDataInterceptor;
import org.jboss.aspects.remoting.NotRegisteredException;
import org.jboss.aspects.remoting.ReplicantsManagerInterceptor;
import org.jboss.aspects.security.SecurityClientInterceptor;
import org.jboss.aspects.tx.ClientTxPropagationInterceptor;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.HAPartitionLocator;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

public class ClusteredRemoting
implements ClusterConstants {
    private static final Logger log = Logger.getLogger(ClusteredRemoting.class);

    public static ClassProxy clusterObject(Object objectId, Object obj, String partitionName, LoadBalancePolicy lb, InvokerLocator locator) throws Exception {
        ClassProxy proxy;
        Class<?> clazz;
        String proxyFamilyName = objectId.toString() + locator.getProtocol() + partitionName;
        HAPartition partition = HAPartitionLocator.getHAPartitionLocator().getHAPartition(partitionName, null);
        HATarget target = null;
        HashMap<String, HATarget> families = null;
        InstanceAdvisor advisor = null;
        if (obj instanceof Advised) {
            advisor = ((Advised)obj)._getInstanceAdvisor();
            clazz = obj.getClass();
            Dispatcher.singleton.registerTarget(objectId, obj);
        } else {
            clazz = obj.getClass();
            proxy = ClassProxyFactory.newInstance(obj.getClass());
            advisor = proxy._getInstanceAdvisor();
            advisor.insertInterceptor((Interceptor)new ForwardingInterceptor(obj));
            Dispatcher.singleton.registerTarget(objectId, (Object)proxy);
        }
        families = (HashMap<String, HATarget>)advisor.getMetaData().getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILIES");
        if (families != null) {
            target = (HATarget)families.get(proxyFamilyName);
            if (target == null) {
                target = new HATarget(partition, proxyFamilyName, (Serializable)locator, 2);
                ClusteringTargetsRepository.initTarget((String)proxyFamilyName, (List)target.getReplicants());
                families.put(proxyFamilyName, target);
            }
        } else {
            families = new HashMap<String, HATarget>();
            target = new HATarget(partition, proxyFamilyName, (Serializable)locator, 2);
            ClusteringTargetsRepository.initTarget((String)proxyFamilyName, (List)target.getReplicants());
            families.put(proxyFamilyName, target);
            advisor.insertInterceptor(0, (Interceptor)new ReplicantsManagerInterceptor(families));
        }
        proxy = ClassProxyFactory.newInstance(clazz);
        InstanceAdvisor proxyAdvisor = proxy._getInstanceAdvisor();
        proxyAdvisor.insertInterceptor((Interceptor)IsLocalInterceptor.singleton);
        advisor.insertInterceptor((Interceptor)SecurityClientInterceptor.singleton);
        advisor.insertInterceptor((Interceptor)ClientTxPropagationInterceptor.singleton);
        proxyAdvisor.insertInterceptor((Interceptor)MergeMetaDataInterceptor.singleton);
        proxyAdvisor.insertInterceptor((Interceptor)ClusterChooserInterceptor.singleton);
        proxyAdvisor.insertInterceptor((Interceptor)InvokeRemoteInterceptor.singleton);
        proxyAdvisor.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILY_WRAPPER", (Object)new FamilyWrapper(proxyFamilyName, (List)target.getReplicants()), PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData((Object)"CLUSTERED_REMOTING", (Object)"LOADBALANCE_POLICY", (Object)lb, PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData((Object)"REMOTING", (Object)"SUBSYSTEM", (Object)"AOP", PayloadKey.AS_IS);
        proxyAdvisor.getMetaData().addMetaData((Object)"DISPATCHER", (Object)"OID", objectId, PayloadKey.AS_IS);
        return proxy;
    }

    public static void unregisterClusteredObject(Object object) {
        try {
            ClassProxy proxy = (ClassProxy)object;
            InstanceAdvisor advisor = proxy._getInstanceAdvisor();
            String oid = (String)advisor.getMetaData().getMetaData((Object)"DISPATCHER", (Object)"OID");
            InstanceAdvised registeredObject = (InstanceAdvised)Dispatcher.singleton.getRegistered((Object)oid);
            if (registeredObject == null) {
                throw new NotRegisteredException(oid.toString() + " is not registered");
            }
            Dispatcher.singleton.unregisterTarget((Object)oid);
            advisor = registeredObject._getInstanceAdvisor();
            Map families = (Map)advisor.getMetaData().getMetaData((Object)"CLUSTERED_REMOTING", (Object)"CLUSTER_FAMILIES");
            for (HATarget target : families.values()) {
                target.destroy();
            }
        }
        catch (Exception ignored) {
            log.trace((Object)"Ignored exception unregistering a clustered object", (Throwable)ignored);
        }
    }
}

