/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.classloader;

import org.jboss.classloading.spi.metadata.RequirementsMetaData;
import org.jboss.classloading.spi.metadata.helpers.AbstractRequirement;
import org.jboss.deployers.vfs.plugins.classloader.RequirementIntegrationDeployer;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachingRequirementIntegrationDeployer<T>
extends RequirementIntegrationDeployer<T> {
    public static final String REQUIREMENT_KEY = CachingRequirementIntegrationDeployer.class.getSimpleName() + "::Requirement";
    private boolean cacheRequirement;

    protected CachingRequirementIntegrationDeployer(Class<T> input) {
        super(input);
    }

    public void setCacheRequirement(boolean cacheRequirement) {
        this.cacheRequirement = cacheRequirement;
    }

    @Override
    public void undeploy(VFSDeploymentUnit unit, T deployment) {
        super.undeploy(unit, deployment);
        if (unit.isAttachmentPresent(REQUIREMENT_KEY)) {
            unit.removeAttachment(REQUIREMENT_KEY);
        }
    }

    @Override
    protected AbstractRequirement hasIntegrationModuleRequirement(VFSDeploymentUnit unit, RequirementsMetaData requirements) {
        AbstractRequirement abstractRequirement = (AbstractRequirement)unit.getAttachment(REQUIREMENT_KEY, AbstractRequirement.class);
        if (abstractRequirement == null) {
            abstractRequirement = super.hasIntegrationModuleRequirement(unit, requirements);
            if (this.cacheRequirement) {
                unit.addAttachment(REQUIREMENT_KEY, (Object)abstractRequirement, AbstractRequirement.class);
            }
        }
        return abstractRequirement;
    }
}

