/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.process;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.as.process.ProcessController;
import org.jboss.as.process.ProcessLogger;
import org.jboss.as.process.ProcessMessageHandler;
import org.jboss.as.process.ProcessMessages;
import org.jboss.as.process.RespawnPolicy;
import org.jboss.as.process.protocol.StreamUtils;
import org.jboss.logging.Logger;

final class ManagedProcess {
    private final String processName;
    private final List<String> command;
    private final Map<String, String> env;
    private final String workingDirectory;
    private final ProcessLogger log;
    private final Object lock;
    private final ProcessController processController;
    private final byte[] authKey;
    private final boolean isPrivileged;
    private final RespawnPolicy respawnPolicy;
    private OutputStream stdin;
    private volatile State state = State.DOWN;
    private Process process;
    private boolean shutdown;
    private boolean stopRequested = false;
    private final AtomicInteger respawnCount = new AtomicInteger(0);

    public byte[] getAuthKey() {
        return this.authKey;
    }

    public boolean isPrivileged() {
        return this.isPrivileged;
    }

    public boolean isRunning() {
        return this.state == State.STARTED;
    }

    ManagedProcess(String processName, List<String> command, Map<String, String> env, String workingDirectory, Object lock, ProcessController controller, byte[] authKey, boolean privileged, boolean respawn) {
        if (processName == null) {
            throw ProcessMessages.MESSAGES.nullVar("processName");
        }
        if (command == null) {
            throw ProcessMessages.MESSAGES.nullVar("command");
        }
        if (env == null) {
            throw ProcessMessages.MESSAGES.nullVar("env");
        }
        if (workingDirectory == null) {
            throw ProcessMessages.MESSAGES.nullVar("workingDirectory");
        }
        if (lock == null) {
            throw ProcessMessages.MESSAGES.nullVar("lock");
        }
        if (controller == null) {
            throw ProcessMessages.MESSAGES.nullVar("controller");
        }
        if (authKey == null) {
            throw ProcessMessages.MESSAGES.nullVar("authKey");
        }
        if (authKey.length != 16) {
            throw ProcessMessages.MESSAGES.invalidLength("authKey");
        }
        this.processName = processName;
        this.command = command;
        this.env = env;
        this.workingDirectory = workingDirectory;
        this.lock = lock;
        this.processController = controller;
        this.authKey = authKey;
        this.isPrivileged = privileged;
        this.respawnPolicy = respawn ? RespawnPolicy.RESPAWN : RespawnPolicy.NONE;
        this.log = (ProcessLogger)Logger.getMessageLogger(ProcessLogger.class, (String)("org.jboss.as.process." + processName + ".status"));
    }

    int incrementAndGetRespawnCount() {
        return this.respawnCount.incrementAndGet();
    }

    int resetRespawnCount() {
        return this.respawnCount.getAndSet(0);
    }

    public String getProcessName() {
        return this.processName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.DOWN) {
                this.log.debugf("Attempted to start already-running process '%s'", this.processName);
                return;
            }
            this.resetRespawnCount();
            this.doStart(false);
        }
    }

    public void sendStdin(InputStream msg) throws IOException {
        assert (Thread.holdsLock(this.lock));
        try {
            StreamUtils.copyStream(msg, this.stdin);
            this.stdin.flush();
        }
        catch (IOException e) {
            this.log.failedToSendDataBytes(e, this.processName);
            throw e;
        }
    }

    public void reconnect(String hostName, int port, boolean managementSubsystemEndpoint, byte[] asAuthKey) {
        assert (Thread.holdsLock(this.lock));
        try {
            StreamUtils.writeUTFZBytes(this.stdin, hostName);
            StreamUtils.writeInt(this.stdin, port);
            StreamUtils.writeBoolean(this.stdin, managementSubsystemEndpoint);
            this.stdin.write(asAuthKey);
            this.stdin.flush();
        }
        catch (IOException e) {
            this.log.failedToSendReconnect(e, this.processName);
        }
    }

    void doStart(boolean restart) {
        Process process;
        assert (Thread.holdsLock(this.lock));
        this.stopRequested = false;
        ArrayList<String> command = new ArrayList<String>(this.command);
        if (restart) {
            command.add("--process-restarted");
        }
        this.log.startingProcess(this.processName);
        this.log.debugf("Process name='%s' command='%s' workingDirectory='%s'", this.processName, command, this.workingDirectory);
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.environment().putAll(this.env);
        builder.directory(new File(this.workingDirectory));
        try {
            process = builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.processController.operationFailed(this.processName, ProcessMessageHandler.OperationType.START);
            this.log.failedToStartProcess(this.processName);
            return;
        }
        long startTime = System.currentTimeMillis();
        OutputStream stdin = process.getOutputStream();
        InputStream stderr = process.getErrorStream();
        InputStream stdout = process.getInputStream();
        Thread stderrThread = new Thread(new ReadTask(stderr, this.processController.getStderr()));
        stderrThread.setName(String.format("stderr for %s", this.processName));
        stderrThread.start();
        Thread stdoutThread = new Thread(new ReadTask(stdout, this.processController.getStdout()));
        stdoutThread.setName(String.format("stdout for %s", this.processName));
        stdoutThread.start();
        Thread joinThread = new Thread(new JoinTask(startTime));
        joinThread.setName(String.format("reaper for %s", this.processName));
        joinThread.start();
        boolean ok = false;
        try {
            stdin.write(this.authKey);
            stdin.flush();
            ok = true;
        }
        catch (Exception e) {
            this.log.failedToSendAuthKey(this.processName, e);
        }
        this.process = process;
        this.stdin = stdin;
        if (ok) {
            this.state = State.STARTED;
            this.processController.processStarted(this.processName);
        } else {
            this.processController.operationFailed(this.processName, ProcessMessageHandler.OperationType.START);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.STARTED) {
                this.log.debugf("Attempted to stop already-stopping or down process '%s'", this.processName);
                return;
            }
            this.log.stoppingProcess(this.processName);
            this.stopRequested = true;
            StreamUtils.safeClose(this.stdin);
            this.state = State.STOPPING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            if (this.state == State.STARTED) {
                this.log.stoppingProcess(this.processName);
                this.stopRequested = true;
                StreamUtils.safeClose(this.stdin);
                this.state = State.STOPPING;
            } else {
                new Thread(){

                    @Override
                    public void run() {
                        ManagedProcess.this.processController.removeProcess(ManagedProcess.this.processName);
                    }
                }.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void respawn() {
        Object object = this.lock;
        synchronized (object) {
            if (this.state != State.DOWN) {
                this.log.debugf("Attempted to respawn already-running process '%s'", this.processName);
                return;
            }
            this.doStart(true);
        }
    }

    private final class ReadTask
    implements Runnable {
        private final InputStream source;
        private final PrintStream target;

        private ReadTask(InputStream source, PrintStream target) {
            this.source = source;
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InputStream source = this.source;
            String processName = ManagedProcess.this.processName;
            try {
                String s;
                BufferedReader reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(source)));
                OutputStreamWriter writer = new OutputStreamWriter(this.target);
                while ((s = reader.readLine()) != null) {
                    PrintStream printStream = this.target;
                    synchronized (printStream) {
                        writer.write(91);
                        writer.write(processName);
                        writer.write("] ");
                        writer.write(s);
                        writer.write(10);
                        writer.flush();
                    }
                }
                source.close();
            }
            catch (IOException e) {
                ManagedProcess.this.log.streamProcessingFailed(processName, e);
            }
            finally {
                StreamUtils.safeClose(source);
            }
        }
    }

    private final class JoinTask
    implements Runnable {
        private final long startTime;

        public JoinTask(long startTime) {
            this.startTime = startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int exitCode;
            Process process;
            Object object = ManagedProcess.this.lock;
            synchronized (object) {
                process = ManagedProcess.this.process;
            }
            while (true) {
                try {
                    exitCode = process.waitFor();
                    ManagedProcess.this.log.processFinished(ManagedProcess.this.processName, exitCode);
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
            boolean respawn = false;
            int respawnCount = 0;
            Object object2 = ManagedProcess.this.lock;
            synchronized (object2) {
                long endTime = System.currentTimeMillis();
                ManagedProcess.this.processController.processStopped(ManagedProcess.this.processName, endTime - this.startTime);
                ManagedProcess.this.state = State.DOWN;
                if (ManagedProcess.this.shutdown) {
                    ManagedProcess.this.processController.removeProcess(ManagedProcess.this.processName);
                } else if (ManagedProcess.this.isPrivileged() && exitCode == 99) {
                    ManagedProcess.this.processController.removeProcess(ManagedProcess.this.processName);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ManagedProcess.this.processController.shutdown();
                            System.exit(0);
                        }
                    }).start();
                } else if (ManagedProcess.this.isPrivileged() && exitCode == 10) {
                    ManagedProcess.this.processController.removeProcess(ManagedProcess.this.processName);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            ManagedProcess.this.processController.shutdown();
                            System.exit(10);
                        }
                    }).start();
                } else if (!ManagedProcess.this.stopRequested) {
                    respawn = true;
                    respawnCount = ManagedProcess.this.incrementAndGetRespawnCount();
                }
                ManagedProcess.this.stopRequested = false;
            }
            if (respawn) {
                ManagedProcess.this.respawnPolicy.respawn(respawnCount, ManagedProcess.this);
            }
        }
    }

    static enum State {
        DOWN,
        STARTED,
        STOPPING;

    }
}

