/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.deployment;

import org.jboss.as.server.deployment.Services;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.osgi.deployment.deployer.Deployment;

public class DeploymentHolderService
extends AbstractService<Deployment> {
    private static final ServiceName SERVICE_NAME_BASE = ServiceName.JBOSS.append(new String[]{"osgi", "deployment", "holder"});
    private final Deployment deployment;

    private DeploymentHolderService(Deployment deployment) {
        this.deployment = deployment;
    }

    public static void addService(ServiceTarget serviceTarget, String contextName, Deployment dep) {
        DeploymentHolderService service = new DeploymentHolderService(dep);
        ServiceBuilder builder = serviceTarget.addService(DeploymentHolderService.getServiceName(contextName), (Service)service);
        builder.install();
    }

    public static ServiceController<Deployment> getDeployment(ServiceRegistry registry, String contextName) {
        return registry.getService(DeploymentHolderService.getServiceName(contextName));
    }

    public static String getContextName(Deployment dep) {
        int idx;
        String prefix;
        String name = dep.getLocation();
        if (name.startsWith(prefix = "module:deployment.")) {
            name = name.substring(prefix.length());
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((idx = name.lastIndexOf("/")) > 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public static ServiceName getServiceName(String contextName) {
        ServiceName deploymentServiceName = Services.deploymentUnitName((String)contextName);
        return SERVICE_NAME_BASE.append(new String[]{deploymentServiceName.getSimpleName()});
    }

    public Deployment getValue() throws IllegalStateException {
        return this.deployment;
    }
}

