/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server.security;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.controller.security.SubjectUserInfo;
import org.jboss.as.domain.http.server.HttpServerLogger;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.security.AuthenticationProvider;
import org.jboss.as.domain.http.server.security.AuthorizingCallbackHandler;
import org.jboss.as.domain.http.server.security.NonceFactory;
import org.jboss.as.domain.http.server.security.SecurityActions;
import org.jboss.com.sun.net.httpserver.Authenticator;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;
import org.jboss.com.sun.net.httpserver.HttpPrincipal;
import org.jboss.com.sun.net.httpserver.HttpsExchange;
import org.jboss.sasl.callback.DigestHashCallback;
import org.jboss.sasl.util.HexConverter;

public class DigestAuthenticator
extends Authenticator {
    private static final String USE_CONNECTION_LOCAL_NONCES_PROPERTY = "org.jboss.domain.http.USE_LOCAL_NONCES";
    private static final boolean USE_CONNECTION_LOCAL_NONCES = SecurityActions.getBoolean("org.jboss.domain.http.USE_LOCAL_NONCES");
    private final NonceFactory theNonceFactory = new NonceFactory();
    private final AuthenticationProvider authenticationProvider;
    private final ThreadLocal<AuthorizingCallbackHandler> callbackHandler = new ThreadLocal();
    private final String realm;
    private final boolean preDigested;
    private static final byte COLON = 58;
    private static final String CHALLENGE = "Digest";
    private static final String NONCE = "nonce";
    private static final String MD5 = "MD5";
    private static final String REALM = "realm";
    private static final String RESPONSE = "response";
    private static final String USERNAME = "username";
    private static final String URI = "uri";

    public DigestAuthenticator(AuthenticationProvider authenticationProvider, String realm, boolean preDigested) {
        this.authenticationProvider = authenticationProvider;
        this.realm = realm;
        this.preDigested = preDigested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authenticator.Result authenticate(HttpExchange httpExchange) {
        Set<HttpPrincipal> httpPrincipals;
        Subject subject = (Subject)httpExchange.getAttribute(Subject.class.getName(), HttpExchange.AttributeScope.CONNECTION);
        if (subject != null && (httpPrincipals = subject.getPrincipals(HttpPrincipal.class)).size() > 0) {
            return new Authenticator.Success(httpPrincipals.iterator().next());
        }
        this.callbackHandler.set(this.authenticationProvider.getCallbackHandler());
        try {
            Authenticator.Result result = this._authenticate(httpExchange);
            return result;
        }
        finally {
            this.callbackHandler.set(null);
        }
    }

    private Authenticator.Result _authenticate(HttpExchange httpExchange) {
        HttpsExchange httpsExch;
        SSLSession session;
        Authenticator.Result response = null;
        if (httpExchange instanceof HttpsExchange && (session = (httpsExch = (HttpsExchange)httpExchange).getSSLSession()) != null) {
            try {
                Principal p = session.getPeerPrincipal();
                response = new Authenticator.Success(new HttpPrincipal(p.getName(), this.realm));
            }
            catch (SSLPeerUnverifiedException e) {
                // empty catch block
            }
        }
        if (response == null) {
            response = this.digestAuth(httpExchange);
        }
        if (response instanceof Authenticator.Success) {
            HttpPrincipal principal = ((Authenticator.Success)response).getPrincipal();
            try {
                SubjectUserInfo userInfo = this.callbackHandler.get().createSubjectUserInfo((Principal)principal);
                httpExchange.setAttribute(Subject.class.getName(), (Object)userInfo.getSubject(), HttpExchange.AttributeScope.CONNECTION);
            }
            catch (IOException e) {
                HttpServerLogger.ROOT_LOGGER.debug("Unable to create SubjectUserInfo", e);
                response = new Authenticator.Failure(500);
            }
        }
        return response;
    }

    private Authenticator.Result digestAuth(HttpExchange httpExchange) {
        DigestContext context = DigestAuthenticator.getOrCreateNegotiationContext(httpExchange, this.theNonceFactory, false);
        if (context.isAuthenticated()) {
            return new Authenticator.Success(context.getPrincipal());
        }
        Headers requestHeaders = httpExchange.getRequestHeaders();
        if (!requestHeaders.containsKey((Object)"Authorization")) {
            Headers responseHeaders = httpExchange.getResponseHeaders();
            responseHeaders.add("WWW-Authenticate", "Digest " + DigestAuthenticator.createChallenge(context, this.realm, false));
            return new Authenticator.Retry(401);
        }
        String authorizationHeader = requestHeaders.getFirst("Authorization");
        if (!authorizationHeader.startsWith("Digest ")) {
            throw HttpServerMessages.MESSAGES.invalidAuthorizationHeader();
        }
        String challenge = authorizationHeader.substring(CHALLENGE.length() + 1);
        Map<String, String> challengeParameters = this.parseDigestChallenge(challenge);
        HttpPrincipal principal = this.validateUser(httpExchange, challengeParameters);
        if (principal == null) {
            if (challengeParameters.containsKey(NONCE)) {
                context.useNonce(challengeParameters.get(NONCE));
            }
            Headers responseHeaders = httpExchange.getResponseHeaders();
            responseHeaders.add("WWW-Authenticate", "Digest " + DigestAuthenticator.createChallenge(context, this.realm, false));
            return new Authenticator.Retry(401);
        }
        if (context.useNonce(challengeParameters.get(NONCE))) {
            context.principal = principal;
            return new Authenticator.Success(principal);
        }
        Headers responseHeaders = httpExchange.getResponseHeaders();
        responseHeaders.add("WWW-Authenticate", "Digest " + DigestAuthenticator.createChallenge(context, this.realm, true));
        return new Authenticator.Retry(401);
    }

    private HttpPrincipal validateUser(HttpExchange httpExchange, Map<String, String> challengeParameters) {
        String realm = challengeParameters.get(REALM);
        String username = challengeParameters.get(USERNAME);
        if (realm == null || realm.length() == 0 || username == null || username.length() == 0) {
            return null;
        }
        RealmCallback rcb = new RealmCallback("Realm", realm);
        NameCallback ncb = new NameCallback("Username", username);
        Object credentialCallback = this.preDigested ? new DigestHashCallback("Password Digest") : new PasswordCallback("Password", false);
        Callback[] callbacks = new Callback[]{rcb, ncb, credentialCallback};
        try {
            this.callbackHandler.get().handle(callbacks);
        }
        catch (Exception e) {
            if (HttpServerLogger.ROOT_LOGGER.isDebugEnabled()) {
                HttpServerLogger.ROOT_LOGGER.debug("Callback handler failed", e);
            }
            return null;
        }
        try {
            byte[] ha1;
            MessageDigest md = MessageDigest.getInstance(MD5);
            if (this.preDigested) {
                Object dhc = credentialCallback;
                ha1 = dhc.getHexHash().getBytes();
            } else {
                md.update(challengeParameters.get(USERNAME).getBytes());
                md.update((byte)58);
                md.update(challengeParameters.get(REALM).getBytes());
                md.update((byte)58);
                PasswordCallback pcb = (PasswordCallback)credentialCallback;
                md.update(new String(pcb.getPassword()).getBytes());
                ha1 = HexConverter.convertToHexBytes((byte[])md.digest());
            }
            md.update(httpExchange.getRequestMethod().getBytes());
            md.update((byte)58);
            md.update(challengeParameters.get(URI).getBytes());
            byte[] ha2 = HexConverter.convertToHexBytes((byte[])md.digest());
            md.update(ha1);
            md.update((byte)58);
            md.update(challengeParameters.get(NONCE).getBytes());
            md.update((byte)58);
            md.update(ha2);
            byte[] expectedResponse = HexConverter.convertToHexBytes((byte[])md.digest());
            byte[] actualResponse = challengeParameters.get(RESPONSE).getBytes();
            if (MessageDigest.isEqual(expectedResponse, actualResponse)) {
                return new HttpPrincipal(challengeParameters.get(USERNAME), challengeParameters.get(REALM));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw HttpServerMessages.MESSAGES.md5Unavailable(e);
        }
        return null;
    }

    public static String createChallenge(DigestContext context, String realm, boolean stale) {
        StringBuilder challenge = new StringBuilder();
        challenge.append("realm=\"").append(realm).append("\",");
        challenge.append("nonce=\"").append(context.createNonce()).append("\"");
        if (stale) {
            challenge.append(",stale=true");
        }
        return challenge.toString();
    }

    private Map<String, String> parseDigestChallenge(String challenge) {
        HashMap<String, String> response = new HashMap<String, String>();
        HeaderParser parser = new HeaderParser(challenge);
        while (parser.hasNext()) {
            HeaderParser.Parameter next = parser.next();
            response.put(next.key, next.value);
        }
        return response;
    }

    public static DigestContext getOrCreateNegotiationContext(HttpExchange httpExchange, NonceFactory nonceFactory, boolean forceCreate) {
        Headers headers = httpExchange.getRequestHeaders();
        boolean proxied = headers.containsKey((Object)"Via");
        if (proxied || forceCreate) {
            return new DigestContext(nonceFactory, false);
        }
        DigestContext context = (DigestContext)httpExchange.getAttribute("DIGEST_CONTEXT", HttpExchange.AttributeScope.CONNECTION);
        if (context == null) {
            context = new DigestContext(nonceFactory, USE_CONNECTION_LOCAL_NONCES);
            httpExchange.setAttribute("DIGEST_CONTEXT", (Object)context, HttpExchange.AttributeScope.CONNECTION);
        }
        return context;
    }

    public static boolean requiredCallbacksSupported(Class[] callbacks) {
        if (!DigestAuthenticator.contains(NameCallback.class, callbacks)) {
            return false;
        }
        if (!DigestAuthenticator.contains(RealmCallback.class, callbacks)) {
            return false;
        }
        return DigestAuthenticator.contains(PasswordCallback.class, callbacks) || DigestAuthenticator.contains(DigestHashCallback.class, callbacks);
    }

    private static boolean contains(Class clazz, Class[] classes) {
        for (Class current : classes) {
            if (!current.equals(clazz)) continue;
            return true;
        }
        return false;
    }

    public static class DigestContext {
        private static final String KEY = "DIGEST_CONTEXT";
        private final NonceFactory theNonceFactory;
        private final boolean localStore;
        private HttpPrincipal principal = null;
        private String nonce = null;

        DigestContext(NonceFactory theNonceFactory, boolean localStore) {
            this.localStore = localStore;
            this.theNonceFactory = theNonceFactory;
        }

        boolean isAuthenticated() {
            return this.principal != null;
        }

        HttpPrincipal getPrincipal() {
            return this.principal;
        }

        String createNonce() {
            String nonce = this.theNonceFactory.createNonce(!this.localStore);
            if (this.localStore) {
                this.nonce = nonce;
            }
            return nonce;
        }

        public boolean useNonce(String nonceToUse) {
            if (this.localStore) {
                if (nonceToUse.equals(this.nonce)) {
                    this.nonce = null;
                    return true;
                }
                return false;
            }
            return this.theNonceFactory.useNonce(nonceToUse);
        }
    }

    private class HeaderParser {
        private static final char EQUALS = '=';
        private static final char DELIMITER = ',';
        private static final char QUOTE = '\"';
        private static final char ESCAPE = '\\';
        private final String message;
        private final int length;
        private int pos = 0;
        private boolean hasNextConfirmed;

        HeaderParser(String message) {
            this.message = message;
            this.length = message.length();
        }

        boolean hasNext() {
            if (this.hasNextConfirmed) {
                return true;
            }
            if (this.pos >= this.length) {
                return false;
            }
            int nextEquals = this.message.indexOf(61, this.pos);
            if (nextEquals < 0 || nextEquals >= this.length - 1) {
                return false;
            }
            this.hasNextConfirmed = true;
            return true;
        }

        Parameter next() {
            if (!this.hasNextConfirmed && !this.hasNext()) {
                return null;
            }
            Parameter response = new Parameter();
            int equalsPos = this.message.indexOf(61, this.pos);
            response.key = this.message.substring(this.pos, equalsPos).trim();
            this.pos = equalsPos + 1;
            int nextDelimiter = this.message.indexOf(44, this.pos);
            int nextQuote = this.message.indexOf(34, this.pos);
            boolean quoted = false;
            if (nextQuote > 0 && (nextDelimiter < 0 || nextQuote < nextDelimiter)) {
                quoted = true;
            }
            if (quoted) {
                String dropping = this.message.substring(this.pos, nextQuote).trim();
                if (!"".equals(dropping)) {
                    throw HttpServerMessages.MESSAGES.unexpectedHeaderChar(dropping, response.key);
                }
                this.pos = nextQuote;
                int endQuote = -1;
                while (endQuote < 0) {
                    if ((nextQuote = this.message.indexOf(34, nextQuote + 1)) < 0) {
                        throw HttpServerMessages.MESSAGES.missingClosingQuote(response.key);
                    }
                    if (this.message.charAt(nextQuote - 1) == '\\') continue;
                    endQuote = nextQuote;
                }
                response.value = this.message.substring(this.pos + 1, endQuote);
                int nextDelimeter = this.message.indexOf(44, this.pos);
                if (nextDelimeter > 0) {
                    this.pos = nextDelimeter + 1;
                }
            } else {
                int nextDelimeter = this.message.indexOf(44, this.pos);
                if (nextDelimeter > 0) {
                    response.value = this.message.substring(this.pos, nextDelimeter).trim();
                    this.pos = nextDelimeter + 1;
                } else {
                    response.value = this.message.substring(this.pos, this.length - 1).trim();
                    this.pos = this.length + 1;
                }
            }
            this.hasNextConfirmed = false;
            return response;
        }

        class Parameter {
            String key;
            String value;

            Parameter() {
            }
        }
    }
}

