/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ejb3.component.EJBViewDescription;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.ejb3.deployment.EjbDeploymentAttachmentKeys;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.webservices.metadata.model.EJBEndpoint;
import org.jboss.as.webservices.metadata.model.JAXRPCDeployment;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.metadata.ejb.spec.EjbJarMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.msc.service.ServiceName;
import org.jboss.wsf.spi.invocation.HandlerCallback;
import org.jboss.wsf.spi.invocation.Invocation;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebserviceDescriptionMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public final class WSIntegrationProcessorJAXRPC_EJB
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (WSIntegrationProcessorJAXRPC_EJB.isJaxwsEjbDeployment(unit)) {
            return;
        }
        EjbJarMetaData ejbJarMD = (EjbJarMetaData)ASHelper.getOptionalAttachment(unit, EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        WebservicesMetaData webservicesMD = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.WEBSERVICES_METADATA_KEY);
        if (ejbJarMD != null && webservicesMD != null && this.hasJaxRpcMapping(webservicesMD)) {
            EEModuleDescription moduleDescription = (EEModuleDescription)ASHelper.getRequiredAttachment(unit, Attachments.EE_MODULE_DESCRIPTION);
            WSIntegrationProcessorJAXRPC_EJB.createJaxrpcDeployment(unit, webservicesMD, moduleDescription);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private static boolean isJaxwsEjbDeployment(DeploymentUnit unit) {
        return ASHelper.getJaxwsEjbs(unit).size() > 0;
    }

    private static void createJaxrpcDeployment(DeploymentUnit unit, WebservicesMetaData webservicesMD, EEModuleDescription moduleDescription) {
        JAXRPCDeployment jaxrpcDeployment = ASHelper.getJaxrpcDeployment(unit);
        Set<String> securityRoles = WSIntegrationProcessorJAXRPC_EJB.getSecurityRoles(unit);
        for (WebserviceDescriptionMetaData wsDescriptionMD : webservicesMD.getWebserviceDescriptions()) {
            for (PortComponentMetaData portComponentMD : wsDescriptionMD.getPortComponents()) {
                EJBEndpoint ejbEndpoint = WSIntegrationProcessorJAXRPC_EJB.newEjbEndpoint(portComponentMD, moduleDescription, securityRoles);
                jaxrpcDeployment.addEndpoint(ejbEndpoint);
            }
        }
    }

    private static EJBEndpoint newEjbEndpoint(PortComponentMetaData portComponentMD, EEModuleDescription moduleDescription, Set<String> securityRoles) {
        String ejbName = portComponentMD.getEjbLink();
        SessionBeanComponentDescription sessionBean = (SessionBeanComponentDescription)moduleDescription.getComponentByName(ejbName);
        String seiIfaceClassName = portComponentMD.getServiceEndpointInterface();
        EJBViewDescription ejbViewDescription = sessionBean.addWebserviceEndpointView(seiIfaceClassName);
        sessionBean.getConfigurators().addLast(new JAXRPCHandlersConfigurator());
        ServiceName ejbViewName = ejbViewDescription.getServiceName();
        return new EJBEndpoint(sessionBean, ejbViewName, securityRoles, null, false, null);
    }

    private static Set<String> getSecurityRoles(DeploymentUnit unit) {
        HashSet<String> securityRoles = new HashSet<String>();
        EjbJarMetaData ejbJarMD = (EjbJarMetaData)unit.getAttachment(EjbDeploymentAttachmentKeys.EJB_JAR_METADATA);
        if (ejbJarMD != null && ejbJarMD.getAssemblyDescriptor() != null) {
            SecurityRolesMetaData securityRolesMD;
            List securityRoleMetaDatas = ejbJarMD.getAssemblyDescriptor().getAny(SecurityRoleMetaData.class);
            if (securityRoleMetaDatas != null) {
                for (SecurityRoleMetaData securityRoleMetaData : securityRoleMetaDatas) {
                    securityRoles.add(securityRoleMetaData.getRoleName());
                }
            }
            if ((securityRolesMD = ejbJarMD.getAssemblyDescriptor().getSecurityRoles()) != null && securityRolesMD.size() > 0) {
                for (SecurityRoleMetaData securityRoleMD : securityRolesMD) {
                    securityRoles.add(securityRoleMD.getRoleName());
                }
            }
        }
        return securityRoles.size() > 0 ? Collections.unmodifiableSet(securityRoles) : Collections.emptySet();
    }

    private boolean hasJaxRpcMapping(WebservicesMetaData webservicesMD) {
        for (WebserviceDescriptionMetaData wsdmd : webservicesMD.getWebserviceDescriptions()) {
            if (wsdmd.getJaxrpcMappingFile() == null) continue;
            return true;
        }
        return false;
    }

    private static final class JAXRPCHandlersInterceptor
    implements Interceptor {
        private static final Interceptor SINGLETON = new JAXRPCHandlersInterceptor();

        private JAXRPCHandlersInterceptor() {
        }

        public Object processInvocation(InterceptorContext context) throws Exception {
            SOAPMessageContext msgContext = (SOAPMessageContext)context.getPrivateData(MessageContext.class);
            Invocation wsInvocation = (Invocation)context.getPrivateData(Invocation.class);
            HandlerCallback callback = (HandlerCallback)context.getPrivateData(HandlerCallback.class);
            if (msgContext == null || callback == null || wsInvocation == null) {
                return context.proceed();
            }
            try {
                boolean handlersPass = callback.callRequestHandlerChain(wsInvocation, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                boolean bl = handlersPass = handlersPass && callback.callRequestHandlerChain(wsInvocation, UnifiedHandlerMetaData.HandlerType.POST);
                if (handlersPass) {
                    Object[] reqParams = wsInvocation.getArgs();
                    context.setParameters(reqParams);
                    Object resObj = context.proceed();
                    msgContext.setMessage(null);
                    wsInvocation.setReturnValue(resObj);
                }
                handlersPass = (handlersPass = callback.callResponseHandlerChain(wsInvocation, UnifiedHandlerMetaData.HandlerType.POST)) && callback.callResponseHandlerChain(wsInvocation, UnifiedHandlerMetaData.HandlerType.ENDPOINT);
                return wsInvocation.getReturnValue();
            }
            catch (Exception ex) {
                try {
                    boolean handlersPass = callback.callFaultHandlerChain(wsInvocation, UnifiedHandlerMetaData.HandlerType.POST, ex);
                    handlersPass = handlersPass && callback.callFaultHandlerChain(wsInvocation, UnifiedHandlerMetaData.HandlerType.ENDPOINT, ex);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw ex;
            }
        }
    }

    private static final class JAXRPCHandlersConfigurator
    implements ComponentConfigurator {
        private JAXRPCHandlersConfigurator() {
        }

        public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
            configuration.addComponentInterceptor((InterceptorFactory)new ImmediateInterceptorFactory(JAXRPCHandlersInterceptor.SINGLETON), 2304, true);
        }
    }
}

